/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.File;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.verifier.facade.VerifierService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

public class VerifyIntegrityRepositoryMojo
extends AbstractRepositoryMojo
implements LogEnabled {
    private Logger logger;
    private EquinoxServiceFactory p2;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File repositoryDir = this.getBuildDirectory().getChild("repository");
        this.logger.info("Verifying p2 repositories in " + repositoryDir);
        VerifierService verifier = (VerifierService)this.p2.getService(VerifierService.class);
        URI repositoryUri = repositoryDir.toURI();
        try {
            if (!verifier.verify(repositoryUri, repositoryUri, this.getBuildDirectory())) {
                throw new MojoFailureException("The repository is invalid.");
            }
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Verification failed", (Exception)((Object)e));
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

