/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.AbstractScanner;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.facade.BuildProperties;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.packaging.IncludeValidationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTychoPackagingMojo
extends AbstractMojo {
    protected MavenSession session;
    protected MavenProject project;
    protected boolean useDefaultExcludes;
    protected String qualifier;
    protected boolean strictBinIncludes;
    protected PlexusContainer plexus;
    protected MavenProjectHelper projectHelper;
    private Map<String, TychoProject> projectTypes;
    private IncludeValidationHelper includeValidationHelper;

    protected FileSet getFileSet(File basedir, List<String> includes, List<String> excludes) {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(basedir);
        fileSet.setIncludes(includes.toArray(new String[includes.size()]));
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>();
        if (excludes != null) {
            allExcludes.addAll(excludes);
        }
        if (this.useDefaultExcludes) {
            allExcludes.addAll(Arrays.asList(AbstractScanner.DEFAULTEXCLUDES));
        }
        fileSet.setExcludes(allExcludes.toArray(new String[allExcludes.size()]));
        return fileSet;
    }

    protected ArtifactDependencyWalker getDependencyWalker() {
        return this.getTychoProjectFacet().getDependencyWalker(this.project);
    }

    protected TychoProject getTychoProjectFacet() {
        return this.getTychoProjectFacet(this.project.getPackaging());
    }

    protected TychoProject getTychoProjectFacet(String packaging) {
        TychoProject facet = this.projectTypes.get(packaging);
        if (facet == null) {
            throw new IllegalStateException("Unknown or unsupported packaging type " + packaging);
        }
        return facet;
    }

    protected DependencyArtifacts getDependencyArtifacts() {
        return this.getTychoProjectFacet().getDependencyArtifacts(this.project);
    }

    protected void expandVersion() {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        String originalVersion = this.getTychoProjectFacet().getArtifactKey(reactorProject).getVersion();
        reactorProject.setExpandedVersion(originalVersion, this.qualifier);
    }

    protected void checkBinIncludesExist(BuildProperties buildProperties, String ... ignoredIncludes) throws MojoExecutionException {
        this.includeValidationHelper.checkBinIncludesExist(this.project, buildProperties, this.strictBinIncludes, ignoredIncludes);
    }
}

