/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;

@Component(role=FeatureXmlTransformer.class)
public class FeatureXmlTransformer {
    private static final int KBYTE = 1024;
    @Requirement
    private Logger log;
    @Requirement
    private FileLockService fileLockService;

    public Feature transform(final ReactorProject reactorProject, Feature source, ArtifactDependencyWalker dependencies) {
        Feature feature = new Feature(source);
        dependencies.traverseFeature(reactorProject.getBasedir(), feature, new ArtifactDependencyVisitor(){

            public void visitPlugin(PluginDescription plugin) {
                PluginRef pluginRef = plugin.getPluginRef();
                if (pluginRef == null) {
                    return;
                }
                File location = plugin.getLocation();
                ReactorProject bundleProject = plugin.getMavenProject();
                if (bundleProject != null) {
                    location = bundleProject.getArtifact(plugin.getClassifier());
                    if (location == null) {
                        throw new IllegalStateException(bundleProject.getId() + " does not provide an artifact with classifier '" + plugin.getClassifier() + "'");
                    }
                    if (location.isDirectory()) {
                        throw new IllegalStateException("At least ``package'' phase execution is required");
                    }
                    pluginRef.setVersion(bundleProject.getExpandedVersion());
                } else {
                    pluginRef.setVersion(plugin.getKey().getVersion());
                }
                long downloadSize = 0L;
                long installSize = 0L;
                if (location.isFile()) {
                    installSize = FeatureXmlTransformer.this.getInstallSize(location);
                    downloadSize = location.length();
                } else {
                    FeatureXmlTransformer.this.log.info("Download/install size is not calculated for directory based bundle " + pluginRef.getId());
                }
                pluginRef.setDownloadSide(downloadSize / 1024L);
                pluginRef.setInstallSize(installSize / 1024L);
            }

            public boolean visitFeature(FeatureDescription feature) {
                FeatureRef featureRef = feature.getFeatureRef();
                if (featureRef == null) {
                    feature.getFeature().setVersion(reactorProject.getExpandedVersion());
                    return true;
                }
                ReactorProject otherProject = feature.getMavenProject();
                if (otherProject != null) {
                    featureRef.setVersion(otherProject.getExpandedVersion());
                } else {
                    featureRef.setVersion(feature.getKey().getVersion());
                }
                return false;
            }
        });
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getInstallSize(File location) {
        long installSize = 0L;
        FileLocker locker = this.fileLockService.getFileLocker(location);
        locker.lock();
        try {
            try {
                JarFile jar = new JarFile(location);
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        long entrySize = entry.getSize();
                        if (entrySize <= 0L) continue;
                        installSize += entrySize;
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not determine installation size", e);
            }
        }
        finally {
            locker.release();
        }
        return installSize;
    }
}

