/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.tycho.core.facade.BuildProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IncludeValidationHelper.class)
public class IncludeValidationHelper {
    @Requirement
    private Logger log;

    public IncludeValidationHelper() {
    }

    public IncludeValidationHelper(Logger log) {
        this.log = log;
    }

    public void checkBinIncludesExist(MavenProject project, BuildProperties buildProperties, boolean strict, String ... ignoredIncludes) throws MojoExecutionException {
        this.checkIncludesExist("bin.includes", buildProperties.getBinIncludes(), project, strict, ignoredIncludes);
    }

    public void checkSourceIncludesExist(MavenProject project, BuildProperties buildProperties, boolean strict) throws MojoExecutionException {
        this.checkIncludesExist("src.includes", buildProperties.getSourceIncludes(), project, strict, new String[0]);
    }

    private void checkIncludesExist(String buildPropertiesKey, List<String> includePatterns, MavenProject project, boolean strict, String ... ignoredIncludes) throws MojoExecutionException {
        String message;
        File baseDir = project.getBasedir();
        ArrayList<String> nonMatchingIncludes = new ArrayList<String>();
        List<String> ignoreList = Arrays.asList(ignoredIncludes);
        if (includePatterns == null || includePatterns.isEmpty()) {
            message = new File(baseDir, "build.properties").getAbsolutePath() + ": " + buildPropertiesKey + " value(s) must be specified.";
            if (strict) {
                throw new MojoExecutionException(message);
            }
            this.log.warn(message);
        }
        for (String includePattern : includePatterns) {
            if (ignoreList.contains(includePattern) || new File(baseDir, includePattern).exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{includePattern});
            scanner.setBasedir(baseDir);
            scanner.scan();
            if (scanner.getIncludedFiles().length != 0) continue;
            nonMatchingIncludes.add(includePattern);
        }
        if (nonMatchingIncludes.size() > 0) {
            message = new File(baseDir, "build.properties").getAbsolutePath() + ": " + buildPropertiesKey + " value(s) " + nonMatchingIncludes + " do not match any files.";
            if (strict) {
                throw new MojoExecutionException(message);
            }
            this.log.warn(message);
        }
    }
}

