/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.facade.BuildProperties;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.SourceReferences;
import org.eclipse.tycho.packaging.sourceref.SourceReferenceComputer;

@Mojo(name="package-plugin")
public class PackagePluginMojo
extends AbstractTychoPackagingMojo {
    @Parameter(property="project.build.directory", required=true)
    protected File buildDirectory;
    protected EclipsePluginProject pdeProject;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private DefaultFileSet[] additionalFileSets;
    @Parameter(property="project.build.finalName", alias="jarName", required=true)
    protected String finalName;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter
    private SourceReferences sourceReferences = new SourceReferences();
    @Component
    private SourceReferenceComputer soureReferenceComputer;

    public void execute() throws MojoExecutionException {
        this.pdeProject = (EclipsePluginProject)this.project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT);
        this.expandVersion();
        this.createSubJars();
        File pluginFile = this.createPluginJar();
        this.project.getArtifact().setFile(pluginFile);
    }

    private void createSubJars() throws MojoExecutionException {
        for (BuildOutputJar jar : this.pdeProject.getOutputJars()) {
            if (jar.isDirClasspathEntry()) continue;
            this.makeJar(jar);
        }
    }

    private File makeJar(BuildOutputJar jar) throws MojoExecutionException {
        String jarName = jar.getName();
        BuildProperties buildProperties = this.pdeProject.getBuildProperties();
        String customManifest = (String)buildProperties.getJarToManifestMap().get(jarName);
        try {
            File jarFile = new File(this.project.getBasedir(), jarName);
            JarArchiver archiver = new JarArchiver();
            archiver.setDestFile(jarFile);
            archiver.addDirectory(jar.getOutputDirectory());
            if (customManifest != null) {
                for (File sourceFolder : jar.getSourceFolders()) {
                    File manifestFile = new File(sourceFolder, customManifest);
                    if (!manifestFile.isFile()) continue;
                    archiver.setManifest(manifestFile);
                    break;
                }
            }
            archiver.createArchive();
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create jar " + jarName, e);
        }
    }

    private File createPluginJar() throws MojoExecutionException {
        try {
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            File pluginFile = new File(this.buildDirectory, this.finalName + ".jar");
            if (pluginFile.exists()) {
                pluginFile.delete();
            }
            BuildProperties buildProperties = this.pdeProject.getBuildProperties();
            List binIncludesList = buildProperties.getBinIncludes();
            List binExcludesList = buildProperties.getBinExcludes();
            if (this.additionalFileSets != null) {
                for (DefaultFileSet fileSet : this.additionalFileSets) {
                    if (fileSet.getDirectory() == null || !fileSet.getDirectory().isDirectory()) continue;
                    archiver.getArchiver().addFileSet((FileSet)fileSet);
                }
            }
            ArrayList<String> binIncludesIgnoredForValidation = new ArrayList<String>();
            for (BuildOutputJar outputJar : this.pdeProject.getOutputJarMap().values()) {
                String jarName = outputJar.getName();
                if (!binIncludesList.contains(jarName) || !outputJar.isDirClasspathEntry()) continue;
                binIncludesIgnoredForValidation.add(jarName);
                String prefix = ".".equals(jarName) ? "" : jarName;
                archiver.getArchiver().addDirectory(outputJar.getOutputDirectory(), prefix);
            }
            this.checkBinIncludesExist(buildProperties, binIncludesIgnoredForValidation.toArray(new String[0]));
            archiver.getArchiver().addFileSet(this.getFileSet(this.project.getBasedir(), binIncludesList, binExcludesList));
            File manifest = this.updateManifest();
            if (manifest.exists()) {
                this.archive.setManifestFile(manifest);
            }
            archiver.setOutputFile(pluginFile);
            if (!this.archive.isForced()) {
                this.getLog().warn((CharSequence)"ignoring unsupported archive forced = false parameter.");
                this.archive.setForced(true);
            }
            archiver.createArchive(this.session, this.project, this.archive);
            return pluginFile;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updateManifest() throws IOException, MojoExecutionException {
        Manifest mf;
        File mfile = new File(this.project.getBasedir(), "META-INF/MANIFEST.MF");
        FileInputStream is = new FileInputStream(mfile);
        try {
            mf = new Manifest(is);
        }
        finally {
            ((InputStream)is).close();
        }
        Attributes attributes = mf.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        attributes.putValue("Bundle-Version", reactorProject.getExpandedVersion());
        this.soureReferenceComputer.addSourceReferenceHeader(mf, this.sourceReferences, this.project);
        mfile = new File(this.project.getBuild().getDirectory(), "MANIFEST.MF");
        mfile.getParentFile().mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));
        try {
            mf.write(os);
        }
        finally {
            os.close();
        }
        return mfile;
    }
}

