/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.impl.JUnit47Provider;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProviderSelector.class)
public class ProviderSelector {
    @Requirement
    private Map<String, TestFrameworkProvider> providers;
    private static final Comparator<TestFrameworkProvider> VERSION_COMPARATOR = new Comparator<TestFrameworkProvider>(){

        @Override
        public int compare(TestFrameworkProvider p1, TestFrameworkProvider p2) {
            return p1.getVersion().compareTo(p2.getVersion());
        }
    };

    public TestFrameworkProvider selectProvider(List<ClasspathEntry> classpath, Properties providerProperties, String providerHint) throws MojoExecutionException {
        if (providerHint != null) {
            TestFrameworkProvider provider = this.providers.get(providerHint);
            if (provider == null) {
                throw new MojoExecutionException("Could not find test framework provider with role hint '" + providerHint + "'. Available providers: " + this.providers.keySet());
            }
            return provider;
        }
        ArrayList<TestFrameworkProvider> candidates = new ArrayList<TestFrameworkProvider>();
        for (TestFrameworkProvider provider : this.providers.values()) {
            if (!provider.isEnabled(classpath, providerProperties)) continue;
            candidates.add(provider);
        }
        this.validateCandidates(candidates);
        TestFrameworkProvider highestVersionProvider = Collections.max(candidates, VERSION_COMPARATOR);
        this.validate(highestVersionProvider, providerProperties);
        return highestVersionProvider;
    }

    private void validate(TestFrameworkProvider provider, Properties providerProperties) throws MojoExecutionException {
        if ("junit".equals(provider.getType()) && providerProperties.getProperty("parallel") != null && !JUnit47Provider.class.equals(provider.getClass())) {
            throw new MojoExecutionException("Provider " + provider.getClass().getName() + " does not support parallel mode. " + JUnit47Provider.class.getName() + " (i.e. JUnit >= 4.7) is required for this.");
        }
    }

    public Set<org.apache.maven.artifact.Artifact> filterTestFrameworkBundles(TestFrameworkProvider provider, List<org.apache.maven.artifact.Artifact> pluginArtifacts) throws MojoExecutionException {
        LinkedHashSet<org.apache.maven.artifact.Artifact> result = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        ArrayList<Object> requiredArtifacts = new ArrayList<Object>();
        requiredArtifacts.add(new DefaultArtifact("org.eclipse.tycho", "org.eclipse.tycho.surefire.osgibooter", null, null));
        requiredArtifacts.addAll(provider.getRequiredBundles());
        for (Artifact artifact : requiredArtifacts) {
            boolean found = false;
            for (org.apache.maven.artifact.Artifact artifact2 : pluginArtifacts) {
                if (!artifact.getGroupId().equals(artifact2.getGroupId()) || !artifact.getArtifactId().equals(artifact2.getArtifactId())) continue;
                if (artifact.getVersion() != null && !"".equals(artifact.getVersion())) {
                    if (!artifact.getVersion().equals(artifact2.getVersion())) continue;
                    found = true;
                    result.add(artifact2);
                    break;
                }
                found = true;
                result.add(artifact2);
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Unable to locate test framework dependency " + artifact + "\n");
            sb.append("Test framework: " + provider.getSurefireProviderClassName() + "\n");
            sb.append("All plugin artifacts: ");
            for (org.apache.maven.artifact.Artifact artifact3 : pluginArtifacts) {
                sb.append("\n\t").append(artifact3.toString());
            }
            throw new MojoExecutionException(sb.toString());
        }
        return result;
    }

    private void validateCandidates(List<TestFrameworkProvider> candidates) throws MojoExecutionException {
        if (candidates.size() == 0) {
            throw new MojoExecutionException("Could not determine test framework provider. Available providers: " + this.providers.keySet());
        }
        if (candidates.size() == 1) {
            return;
        }
        String firstType = candidates.get(0).getType();
        for (int i = 1; i < candidates.size(); ++i) {
            if (firstType.equals(candidates.get(i).getType())) continue;
            throw new MojoExecutionException("Could not determine test framework provider. Providers with different types (" + firstType + "," + candidates.get(i).getType() + ") are enabled. Try specifying a providerHint; available provider hints: " + this.providers.keySet());
        }
    }
}

