/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class AbstractJUnitProvider
implements TestFrameworkProvider {
    @Override
    public String getType() {
        return "junit";
    }

    @Override
    public boolean isEnabled(List<ClasspathEntry> testBundleClassPath, Properties surefireProperties) {
        Set<String> junitBundleNames = this.getJUnitBundleNames();
        VersionRange range = this.getJUnitVersionRange();
        for (ClasspathEntry classpathEntry : testBundleClassPath) {
            Version version;
            ArtifactKey artifactKey = classpathEntry.getArtifactKey();
            if (!junitBundleNames.contains(artifactKey.getId()) || !range.includes(version = Version.parseVersion((String)artifactKey.getVersion()))) continue;
            return true;
        }
        return false;
    }

    protected abstract VersionRange getJUnitVersionRange();

    protected abstract Set<String> getJUnitBundleNames();
}

