/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.backupconsole;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.exoplatform.jcr.backupconsole.BackupClientImpl;
import org.exoplatform.jcr.backupconsole.BackupExecuteException;
import org.exoplatform.jcr.backupconsole.ClientTransportImpl;
import org.exoplatform.jcr.backupconsole.FormAuthentication;

public class BackupConsole {
    private static final String INCORRECT_PARAM = "Incorrect parameter: ";
    private static final String TOO_MANY_PARAMS = "Too many parameters.";
    private static final String LOGIN_PASS_SPLITTER = ":";
    private static final String FORCE_CLOSE = "force-close-session";
    private static final String HELP_INFO = "Help info:\n <url_basic_authentication>|<url form authentication>  <cmd> \n <url_basic_authentication>  :   http(s)//login:password@host:port/<context> \n\n <url form authentication>   :   http(s)//host:port/<context> \"<form auth parm>\" \n     <form auth parm>        :   form <method> <form path>\n     <method>                :   POST or GET\n     <form path>             :   /path/path?<paramName1>=<paramValue1>&<paramName2>=<paramValue2>...\n     Example to <url form authentication> : http://127.0.0.1:8080/portal/rest form POST \"/portal/login?initialURI=/portal/private&username=root&password=gtn\"\n\n <cmd>  :   start <repo[/ws]> <backup_dir> [<incr>] \n            stop <backup_id> \n            status <backup_id> \n            restores <repo[/ws]> \n            restore [remove-exists] {{<backup_id>|<backup_set_path>} | {<repo[/ws]> {<backup_id>|<backup_set_path>} [<pathToConfigFile>]}} \n            list [completed] \n            info \n            drop [force-close-session] <repo[/ws]>  \n            help  \n\n start          - start backup of repository or workspace \n stop           - stop backup \n status         - information about the current or completed backup by 'backup_id' \n restores       - information about the last restore on specific repository or workspace \n restore        - restore the repository or workspace from specific backup \n list           - information about the current backups (in progress) \n list completed - information about the completed (ready to restore) backups \n info           - information about the service backup \n drop           - delete the repository or workspace \n help           - print help information about backup console \n\n <repo[/ws]>         - /<reponsitory-name>[/<workspace-name>]  the repository or workspace \n <backup_dir>        - path to folder for backup on remote server \n <backup_id>         - the identifier for backup \n <backup_set_dir>    - path to folder with backup set on remote server\n <incr>              - incemental job period \n <pathToConfigFile>  - path (local) to  repository or workspace configuration \n remove-exists       - remove fully (db, value storage, index) exists repository/workspace \n force-close-session - close opened sessions on repository or workspace. \n\n All valid combination of parameters for command restore: \n  1. restore remove-exists <repo/ws> <backup_id>       <pathToConfigFile> \n  2. restore remove-exists <repo>    <backup_id>       <pathToConfigFile> \n  3. restore remove-exists <repo/ws> <backup_set_path> <pathToConfigFile> \n  4. restore remove-exists <repo>    <backup_set_path> <pathToConfigFile> \n  5. restore remove-exists <backup_id> \n  6. restore remove-exists <backup_set_path> \n  7. restore <repo/ws> <backup_id>       <pathToConfigFile> \n  8. restore <repo>    <backup_id>       <pathToConfigFile> \n  9. restore <repo/ws> <backup_set_path> <pathToConfigFile> \n 10. restore <repo>    <backup_set_path> <pathToConfigFile> \n 11. restore <backup_id> \n 12. restore <backup_set_path> \n";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        block63: {
            BackupClientImpl client;
            ClientTransportImpl transport;
            URL url;
            int curArg = 0;
            if (curArg == args.length) {
                System.out.println("Incorrect parameter: There is no any parameters.");
                return;
            }
            if (args[curArg].equalsIgnoreCase("help")) {
                System.out.println(HELP_INFO);
                return;
            }
            String sUrl = args[curArg];
            ++curArg;
            try {
                url = new URL(sUrl);
            }
            catch (MalformedURLException e) {
                System.out.println("Incorrect parameter: There is no url parameter.");
                return;
            }
            String urlPath = null;
            if (!"".equals(url.getPath())) {
                urlPath = url.getPath();
            }
            String form = null;
            if (curArg < args.length && args[curArg].equals("form")) {
                form = args[curArg++];
                if (url.getUserInfo() != null) {
                    System.out.println("Incorrect parameter: Parameters Login:Password should not be specified in url parameter to form authentication - " + sUrl);
                    return;
                }
            }
            String login = url.getUserInfo();
            FormAuthentication formAuthentication = null;
            if (form == null || !form.equals("form")) {
                if (login == null) {
                    System.out.println("Incorrect parameter: There is no specific Login:Password in url parameter - " + sUrl);
                    return;
                }
                if (!login.matches("[^:]+:[^:]+")) {
                    System.out.println("Incorrect parameter: There is incorrect Login:Password parameter - " + login);
                    return;
                }
            } else {
                String[] params;
                String method;
                if (curArg == args.length) {
                    System.out.println("Incorrect parameter: No specified  POST or GET parameter to form parameter.");
                    return;
                }
                if (!(method = args[curArg++]).equalsIgnoreCase("GET") && !method.equalsIgnoreCase("POST")) {
                    System.out.println("Incorrect parameter: Method to form authentication shulde be GET or POST to form parameter - " + method);
                    return;
                }
                if (curArg == args.length) {
                    System.out.println("Incorrect parameter: No specified  url and form properties to form parameter.");
                    return;
                }
                if ((params = args[curArg++].split("[?]")).length != 2) {
                    System.out.println("Incorrect parameter: From parameters is not spacified to form parameter - " + args[curArg]);
                    return;
                }
                String formUrl = params[0];
                String[] formParams = params[1].split("&");
                if (formParams.length < 2) {
                    System.out.println("Incorrect parameter: From parameters shoulde be conatains at least two (for login and for pasword) parameters - " + params[1]);
                    return;
                }
                HashMap<String, String> mapFormParams = new HashMap<String, String>();
                for (String fParam : formParams) {
                    String[] para = fParam.split("=");
                    if (para.length != 2) {
                        System.out.println("Incorrect parameter: From parameters is incorect, shoulde be as \"name=value\"  - " + fParam);
                        return;
                    }
                    mapFormParams.put(para[0], para[1]);
                }
                formAuthentication = new FormAuthentication(method, formUrl, mapFormParams);
            }
            String host = url.getHost() + LOGIN_PASS_SPLITTER + url.getPort();
            if (formAuthentication != null) {
                transport = new ClientTransportImpl(formAuthentication, host, url.getProtocol());
                client = new BackupClientImpl(transport, formAuthentication, urlPath);
            } else {
                String[] lp = login.split(LOGIN_PASS_SPLITTER);
                transport = new ClientTransportImpl(lp[0], lp[1], host, url.getProtocol());
                client = new BackupClientImpl(transport, urlPath);
            }
            if (curArg == args.length) {
                System.out.println("Incorrect parameter: There is no command parameter.");
                return;
            }
            String command = args[curArg++];
            try {
                block64: {
                    String pathToConf;
                    File conf;
                    String parameter;
                    String workspaceName;
                    String repositoryName;
                    String backupId;
                    String backupSetPath;
                    boolean removeExists;
                    block66: {
                        block67: {
                            block65: {
                                String backupId2;
                                String repositoryName2;
                                String pathToWS;
                                if (command.equalsIgnoreCase("start")) {
                                    String workspaceName2;
                                    if ((pathToWS = BackupConsole.getRepoWS(args, curArg++)) == null) {
                                        return;
                                    }
                                    repositoryName2 = BackupConsole.getRepositoryName(pathToWS);
                                    String string = workspaceName2 = pathToWS.split("/").length == 3 ? BackupConsole.getWorkspaceName(pathToWS) : null;
                                    String backupDir = curArg == args.length ? null : (args[curArg].matches("[0-9]+") ? null : args[curArg++]);
                                    if (curArg == args.length) {
                                        System.out.println(client.startBackUp(repositoryName2, workspaceName2, backupDir));
                                        break block63;
                                    }
                                    String incr = args[curArg++];
                                    long inc = 0L;
                                    try {
                                        inc = Long.parseLong(incr);
                                    }
                                    catch (NumberFormatException e) {
                                        System.out.println("Incorrect parameter: Incemental job period is not didgit - " + e.getMessage());
                                        return;
                                    }
                                    if (curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.startIncrementalBackUp(repositoryName2, workspaceName2, backupDir, inc));
                                    break block63;
                                }
                                if (command.equalsIgnoreCase("stop")) {
                                    if (curArg == args.length) {
                                        System.out.println("Incorrect parameter: There is no backup identifier parameter.");
                                        return;
                                    }
                                    backupId2 = args[curArg++];
                                    if (curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.stop(backupId2));
                                    break block63;
                                }
                                if (command.equalsIgnoreCase("drop")) {
                                    String workspaceName3;
                                    if (curArg == args.length) {
                                        System.out.println("Incorrect parameter: There is no path to workspace or force-session-close parameter.");
                                        return;
                                    }
                                    String param = args[curArg++];
                                    boolean isForce = true;
                                    if (!param.equalsIgnoreCase(FORCE_CLOSE)) {
                                        isForce = false;
                                    }
                                    int n = --curArg;
                                    ++curArg;
                                    String pathToWS2 = BackupConsole.getRepoWS(args, n);
                                    if (pathToWS2 == null) {
                                        return;
                                    }
                                    String repositoryName3 = BackupConsole.getRepositoryName(pathToWS2);
                                    String string = workspaceName3 = pathToWS2.split("/").length == 3 ? BackupConsole.getWorkspaceName(pathToWS2) : null;
                                    if (curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.drop(isForce, repositoryName3, workspaceName3));
                                    break block63;
                                }
                                if (command.equalsIgnoreCase("status")) {
                                    if (curArg == args.length) {
                                        System.out.println("Incorrect parameter: There is no backup identifier parameter.");
                                        return;
                                    }
                                    backupId2 = args[curArg++];
                                    if (curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.status(backupId2));
                                    break block63;
                                }
                                if (command.equalsIgnoreCase("info")) {
                                    if (curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.info());
                                    break block63;
                                }
                                if (command.equalsIgnoreCase("restores")) {
                                    String workspaceName4;
                                    if ((pathToWS = BackupConsole.getRepoWS(args, curArg++)) == null) {
                                        return;
                                    }
                                    repositoryName2 = BackupConsole.getRepositoryName(pathToWS);
                                    String string = workspaceName4 = pathToWS.split("/").length == 3 ? BackupConsole.getWorkspaceName(pathToWS) : null;
                                    if (curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.restores(repositoryName2, workspaceName4));
                                    break block63;
                                }
                                if (command.equalsIgnoreCase("list")) {
                                    if (curArg == args.length) {
                                        System.out.println(client.list());
                                        break block63;
                                    } else {
                                        String complated;
                                        if (!(complated = args[curArg++]).equalsIgnoreCase("completed")) {
                                            System.out.println("Incorrect parameter: There is no 'completed' parameter - " + complated);
                                            return;
                                        }
                                        if (curArg < args.length) {
                                            System.out.println(TOO_MANY_PARAMS);
                                            return;
                                        }
                                        System.out.println(client.listCompleted());
                                    }
                                    break block63;
                                }
                                if (!command.equalsIgnoreCase("restore")) break block64;
                                removeExists = false;
                                backupSetPath = null;
                                backupId = null;
                                String pathToWS3 = null;
                                repositoryName = null;
                                workspaceName = null;
                                if ((parameter = args[curArg++]).equals("remove-exists")) {
                                    removeExists = true;
                                    if (curArg == args.length) {
                                        System.out.println("Incorrect parameter: Should be more parameters.");
                                        return;
                                    }
                                }
                                if (removeExists) {
                                    parameter = args[curArg++];
                                }
                                if (BackupConsole.isBackupId(parameter)) {
                                    backupId = parameter;
                                    if (++curArg < args.length) {
                                        System.out.println(TOO_MANY_PARAMS);
                                        return;
                                    }
                                    System.out.println(client.restore(repositoryName, workspaceName, backupId, null, backupSetPath, removeExists));
                                    return;
                                }
                                if (!BackupConsole.isRepoWS(parameter)) break block65;
                                pathToWS3 = BackupConsole.getRepoWS(args, curArg - 1);
                                if (pathToWS3 == null) {
                                    return;
                                }
                                repositoryName = BackupConsole.getRepositoryName(pathToWS3);
                                String string = workspaceName = pathToWS3.split("/").length == 3 ? BackupConsole.getWorkspaceName(pathToWS3) : null;
                                if (curArg != args.length) break block66;
                                break block67;
                            }
                            backupSetPath = parameter;
                            if (curArg < args.length) {
                                System.out.println("Incorrect parameter: Should be less parameters : " + parameter);
                                return;
                            }
                            System.out.println(client.restore(repositoryName, workspaceName, backupId, null, backupSetPath, removeExists));
                            return;
                        }
                        System.out.println("Incorrect parameter: There is no backup identifier or backup set path parameter.");
                        return;
                    }
                    if (BackupConsole.isBackupId(parameter = args[curArg++])) {
                        backupId = parameter;
                    } else {
                        backupSetPath = parameter;
                    }
                    if (curArg == args.length) {
                        System.out.println("Incorrect parameter: The path to the configuration file is missing.");
                        return;
                    }
                    if (!(conf = new File(pathToConf = args[curArg++])).exists()) {
                        System.out.println(" File " + pathToConf + " do not exist. Check the path.");
                        return;
                    }
                    if (curArg < args.length) {
                        System.out.println(TOO_MANY_PARAMS);
                        return;
                    }
                    System.out.println(client.restore(repositoryName, workspaceName, backupId, new FileInputStream(conf), backupSetPath, removeExists));
                    break block63;
                }
                System.out.println("Unknown command <" + command + ">");
            }
            catch (IOException e) {
                System.out.println("ERROR: " + e.getMessage());
                e.printStackTrace();
            }
            catch (BackupExecuteException e) {
                System.out.println("ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    private static boolean isRepoWS(String parameter) {
        String repWS = parameter;
        return (repWS = repWS.replaceAll("\\\\", "/")).matches("[/][^/]+") || repWS.matches("[/][^/]+[/][^/]+");
    }

    private static boolean isBackupId(String parameter) {
        return parameter.matches("[0-9abcdef]+") && parameter.length() == 32;
    }

    private static String getWorkspaceName(String pathToWS) {
        return pathToWS.split("/")[2];
    }

    private static String getRepositoryName(String pathToWS) {
        return pathToWS.split("/")[1];
    }

    private static String getRepoWS(String[] args, int curArg) {
        if (curArg == args.length) {
            System.out.println("Incorrect parameter: There is no path to workspace parameter.");
            return null;
        }
        String repWS = args[curArg];
        if (!(repWS = repWS.replaceAll("\\\\", "/")).matches("[/][^/]+") && !repWS.matches("[/][^/]+[/][^/]+")) {
            System.out.println("Incorrect parameter: There is incorrect path to workspace parameter: " + repWS);
            return null;
        }
        return repWS;
    }
}

