/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.cluster;

import java.io.IOException;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.HttpOutputStream;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;

public class JCRWebdavConnection
extends HTTPConnection {
    private String realm;
    private String user;
    private String pass;
    private String workspacePath;

    public JCRWebdavConnection(String host, int port, String user, String password, String realm, String workspacePath) {
        super(host, port);
        CookieModule.setCookiePolicyHandler(null);
        this.user = user;
        this.pass = password;
        this.realm = realm;
        this.workspacePath = workspacePath;
        this.addBasicAuthorization(this.realm, this.user, this.pass);
    }

    public HTTPResponse addNode(String name, byte[] data) throws IOException, ModuleException {
        HTTPResponse response = this.Put(this.workspacePath + name, data);
        response.getStatusCode();
        return response;
    }

    public void addNode(String name, String nodeType, byte[] data) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("File-NodeType", nodeType)};
        this.Put(this.workspacePath + name, data, headers).getStatusCode();
    }

    public HTTPResponse addNode(String name, String[] mixinTypes, byte[] data) throws IOException, ModuleException {
        StringBuilder mixins = new StringBuilder(mixinTypes.length > 0 ? mixinTypes[0] : "");
        for (int i = 1; i < mixinTypes.length; ++i) {
            mixins.append(", ").append(mixinTypes[i]);
        }
        NVPair[] headers = new NVPair[]{new NVPair("Content-MixinTypes", mixins.toString()), new NVPair("Content-Type", "text/plain")};
        HTTPResponse response = this.Put(this.workspacePath + name, data, headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse addNode(String name, byte[] data, String mimeType) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", mimeType)};
        HTTPResponse response = this.Put(this.workspacePath + name, data, headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse addNode(String name, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Put(this.workspacePath + name, stream);
    }

    public HTTPResponse addNode(String name, HttpOutputStream stream, String mimeType) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", mimeType)};
        return this.Put(this.workspacePath + name, stream, headers);
    }

    public HTTPResponse removeNode(String name) throws IOException, ModuleException {
        HTTPResponse response = this.Delete(this.workspacePath + name);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse getNode(String name) throws IOException, ModuleException {
        HTTPResponse response = this.Get(this.workspacePath + name);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse addProperty(String nodeName, String property) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:propertyupdate xmlns:D='DAV:'><D:set><D:prop><" + property + ">value</" + property + ">" + "</D:prop>" + "</D:set>" + "</D:propertyupdate>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("PROPPATCH", this.workspacePath + nodeName, xmlBody.getBytes(), headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse setProperty(String nodeName, String property, String value) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:propertyupdate xmlns:D='DAV:'><D:set><D:prop><" + property + ">" + value + "</" + property + ">" + "</D:prop>" + "</D:set>" + "</D:propertyupdate>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("PROPPATCH", this.workspacePath + nodeName, xmlBody.getBytes(), headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse getProperty(String nodeName, String property) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:propfind xmlns:D='DAV:' ><D:prop><" + property + "/></D:prop>" + "</D:propfind>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("PROPFIND", this.workspacePath + nodeName, xmlBody.getBytes(), headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse removeProperty(String nodeName, String property) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:propertyupdate xmlns:D='DAV:' xmlns:Z='http://www.w3.com/standards/z39.50/'><D:remove><D:prop><" + property + "/></D:prop>" + "</D:remove>" + "</D:propertyupdate>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("PROPPATCH", this.workspacePath + nodeName, xmlBody.getBytes(), headers);
        response.getStatusCode();
        return response;
    }

    public String lock(String nodeName) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:lockinfo xmlns:D='DAV:'><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype><D:owner>owner</D:owner></D:lockinfo>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("LOCK", this.workspacePath + nodeName, xmlBody.getBytes(), headers);
        response.getStatusCode();
        StringBuffer resp = new StringBuffer(new String(response.getData(), "UTF-8"));
        String lockPrffix = "opaquelocktoken:";
        int pos = resp.lastIndexOf("opaquelocktoken:");
        String lockToken = resp.substring(pos + "opaquelocktoken:".length(), pos + "opaquelocktoken:".length() + 32);
        return lockToken;
    }

    public void unlock(String nodeName, String lockToken) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString("".length())), new NVPair("lock-token", "<" + lockToken + ">")};
        HTTPResponse response = this.ExtensionMethod("UNLOCK", this.workspacePath + nodeName, "".getBytes(), headers);
        response.getStatusCode();
    }

    public void addVersionControl(String nodeName) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Length", Integer.toString("".length()))};
        HTTPResponse response = this.ExtensionMethod("VERSION-CONTROL", this.workspacePath + nodeName, "".getBytes(), headers);
        response.getStatusCode();
    }

    public void checkIn(String nodeName) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Length", Integer.toString("".length()))};
        HTTPResponse response = this.ExtensionMethod("CHECKIN", this.workspacePath + nodeName, "".getBytes(), headers);
        response.getStatusCode();
    }

    public void checkOut(String nodeName) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Length", Integer.toString("".length()))};
        HTTPResponse response = this.ExtensionMethod("CHECKOUT", this.workspacePath + nodeName, "".getBytes(), headers);
        response.getStatusCode();
    }

    public HTTPResponse addDir(String path) throws IOException, ModuleException {
        HTTPResponse mkCol = this.MkCol(this.workspacePath + path);
        mkCol.getStatusCode();
        return mkCol;
    }

    public HTTPResponse restore(String node, String version) throws IOException, ModuleException {
        NVPair[] query = new NVPair[]{new NVPair("version", version)};
        HTTPResponse response = this.Get(this.workspacePath + node, query);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse moveNode(String path, String destination) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Destination", this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + this.workspacePath + destination), new NVPair("Content-Length", Integer.toString("".length()))};
        HTTPResponse response = this.ExtensionMethod("MOVE", this.workspacePath + path, "".getBytes(), headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse xpathQuery(String query) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:searchrequest xmlns:D='DAV:'><D:xpath>" + query + "</D:xpath>" + "</D:searchrequest>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("SEARCH", this.workspacePath, xmlBody.getBytes(), headers);
        response.getStatusCode();
        return response;
    }

    public HTTPResponse sqlQuery(String query) throws IOException, ModuleException {
        String xmlBody = "<?xml version='1.0' encoding='utf-8' ?><D:searchrequest xmlns:D='DAV:'><D:sql>" + query + "</D:sql>" + "</D:searchrequest>";
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml; charset='utf-8'"), new NVPair("Content-Length", Integer.toString(xmlBody.length()))};
        HTTPResponse response = this.ExtensionMethod("SEARCH", this.workspacePath, xmlBody.getBytes(), headers);
        response.getStatusCode();
        return response;
    }
}

