/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.exoplatform.services.ftp.client.FtpClientSession;
import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.ftp.data.FtpDataChannelManager;
import org.exoplatform.services.ftp.data.FtpDataTransiver;
import org.exoplatform.services.ftp.data.FtpSlowInputStream;
import org.exoplatform.services.ftp.data.FtpSlowOutputStream;
import org.exoplatform.services.ftp.data.FtpTimeStampedInputStream;
import org.exoplatform.services.ftp.data.FtpTimeStampedOutputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpDataTransiverImpl
implements FtpDataTransiver {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ftp.FtpDataTransiverImpl");
    private FtpClientSession clientSession;
    private FtpDataChannelManager dataChannelManager;
    private FtpConfig configuration;
    private String host;
    private int dataPort = 0;
    private ServerSocket serverSocket;
    private Socket dataSocket = null;
    private Thread connectionThread;
    private boolean isActive = false;
    private InputStream dataInputStream = null;
    private OutputStream dataOutputStream = null;

    public FtpDataTransiverImpl(FtpDataChannelManager dataChannelManager, int dataPort, FtpConfig configuration, FtpClientSession clientSession) throws Exception {
        this.clientSession = clientSession;
        this.configuration = configuration;
        this.dataChannelManager = dataChannelManager;
        this.dataPort = dataPort;
        this.serverSocket = new ServerSocket(dataPort);
        this.connectionThread = new AcceptDataConnect();
        this.connectionThread.start();
    }

    public FtpDataTransiverImpl(String host, int dataPort, FtpConfig configuration, FtpClientSession clientSession) throws Exception {
        this.clientSession = clientSession;
        this.configuration = configuration;
        this.host = host;
        this.dataPort = dataPort;
        this.isActive = true;
        this.connectionThread = new ConnectDataPort();
        this.connectionThread.start();
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public boolean isConnected() {
        if (this.dataSocket == null) {
            return false;
        }
        return this.dataSocket.isConnected();
    }

    public void close() {
        if (this.connectionThread.isAlive()) {
            try {
                this.connectionThread.stop();
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ioexc) {
                log.info((Object)"Closing socket failure.");
            }
        }
        if (!this.isActive) {
            this.dataChannelManager.freeDataTransiver(this);
        }
        try {
            if (this.dataSocket != null && this.dataSocket.isConnected()) {
                this.dataSocket.close();
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dataOutputStream == null) {
            OutputStream nativeOutputStream = null;
            nativeOutputStream = this.configuration.isNeedTimeOut() ? new FtpTimeStampedOutputStream(this.dataSocket.getOutputStream(), this.clientSession) : this.dataSocket.getOutputStream();
            this.dataOutputStream = this.configuration.isNeedSlowDownLoad() ? new FtpSlowOutputStream(nativeOutputStream, this.configuration.getDownLoadSpeed()) : nativeOutputStream;
        }
        return this.dataOutputStream;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataInputStream == null) {
            InputStream nativeInputStream = null;
            nativeInputStream = this.configuration.isNeedTimeOut() ? new FtpTimeStampedInputStream(this.dataSocket.getInputStream(), this.clientSession) : this.dataSocket.getInputStream();
            this.dataInputStream = this.configuration.isNeedSlowUpLoad() ? new FtpSlowInputStream(nativeInputStream, this.configuration.getUpLoadSpeed()) : nativeInputStream;
        }
        return this.dataInputStream;
    }

    protected class ConnectDataPort
    extends Thread {
        protected Log connectLog = ExoLogger.getLogger((String)"jcr.ConnectDataPort");

        protected ConnectDataPort() {
        }

        public void run() {
            try {
                FtpDataTransiverImpl.this.dataSocket = new Socket();
                InetSocketAddress sockAddr = new InetSocketAddress(FtpDataTransiverImpl.this.host, FtpDataTransiverImpl.this.dataPort);
                FtpDataTransiverImpl.this.dataSocket.connect(sockAddr);
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    protected class AcceptDataConnect
    extends Thread {
        protected Log acceptLog = ExoLogger.getLogger((String)"jcr.AcceptDataConnect");

        protected AcceptDataConnect() {
        }

        public void run() {
            try {
                FtpDataTransiverImpl.this.dataSocket = FtpDataTransiverImpl.this.serverSocket.accept();
                FtpDataTransiverImpl.this.serverSocket.close();
            }
            catch (Exception exc) {
                log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

