/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.statistics;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRAPIAspectConfig {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.statistics.JCRAPIAspectConfig");
    private Class<?>[] targetInterfaces;

    public JCRAPIAspectConfig(InitParams params) {
        this.targetInterfaces = this.loadTargetInterfaces(params.getValuesParam("targetInterfaces"));
    }

    private Class<?>[] loadTargetInterfaces(ValuesParam params) {
        List values = params.getValues();
        ArrayList<Class> lTargetInterfaces = new ArrayList<Class>();
        if (values != null) {
            for (Object o : params.getValues()) {
                String className = null;
                try {
                    className = (String)o;
                    lTargetInterfaces.add(ClassLoading.forName((String)className, (Object)this));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Cannot find the target interface " + className), (Throwable)e);
                }
            }
        }
        Class[] targetInterfaces = new Class[lTargetInterfaces.size()];
        return lTargetInterfaces.toArray(targetInterfaces);
    }

    public Class<?>[] getTargetInterfaces() {
        return this.targetInterfaces;
    }
}

