/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.PreconditionException;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.WebDavService;
import org.exoplatform.services.jcr.webdav.command.CopyCommand;
import org.exoplatform.services.jcr.webdav.command.DeleteCommand;
import org.exoplatform.services.jcr.webdav.command.GetCommand;
import org.exoplatform.services.jcr.webdav.command.HeadCommand;
import org.exoplatform.services.jcr.webdav.command.LockCommand;
import org.exoplatform.services.jcr.webdav.command.MkColCommand;
import org.exoplatform.services.jcr.webdav.command.MoveCommand;
import org.exoplatform.services.jcr.webdav.command.OrderPatchCommand;
import org.exoplatform.services.jcr.webdav.command.PropFindCommand;
import org.exoplatform.services.jcr.webdav.command.PropPatchCommand;
import org.exoplatform.services.jcr.webdav.command.PutCommand;
import org.exoplatform.services.jcr.webdav.command.SearchCommand;
import org.exoplatform.services.jcr.webdav.command.UnLockCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.CheckInCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.CheckOutCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.ReportCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.UnCheckOutCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.VersionControlCommand;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.NodeTypeUtil;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.webdav.method.CHECKIN;
import org.exoplatform.services.rest.ext.webdav.method.CHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.COPY;
import org.exoplatform.services.rest.ext.webdav.method.LOCK;
import org.exoplatform.services.rest.ext.webdav.method.MKCOL;
import org.exoplatform.services.rest.ext.webdav.method.MOVE;
import org.exoplatform.services.rest.ext.webdav.method.OPTIONS;
import org.exoplatform.services.rest.ext.webdav.method.ORDERPATCH;
import org.exoplatform.services.rest.ext.webdav.method.PROPFIND;
import org.exoplatform.services.rest.ext.webdav.method.PROPPATCH;
import org.exoplatform.services.rest.ext.webdav.method.REPORT;
import org.exoplatform.services.rest.ext.webdav.method.SEARCH;
import org.exoplatform.services.rest.ext.webdav.method.UNCHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.UNLOCK;
import org.exoplatform.services.rest.ext.webdav.method.VERSIONCONTROL;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/jcr")
public class WebDavServiceImpl
implements WebDavService,
ResourceContainer {
    public static final String INIT_PARAM_DEF_FOLDER_NODE_TYPE = "def-folder-node-type";
    public static final String INIT_PARAM_DEF_FILE_NODE_TYPE = "def-file-node-type";
    public static final String INIT_PARAM_DEF_FILE_MIME_TYPE = "def-file-mimetype";
    public static final String INIT_PARAM_UPDATE_POLICY = "update-policy";
    private static Log log = ExoLogger.getLogger(WebDavServiceImpl.class);
    private final ThreadLocalSessionProviderService sessionProviderService;
    private final RepositoryService repositoryService;
    private final NullResourceLocksHolder nullResourceLocks;
    private String defaultFolderNodeType = "nt:folder";
    private String defaultFileNodeType = "nt:file";
    private String defaultFileMimeType = "application/octet-stream";
    private String updatePolicyType = "create-version";
    private static final String ALLOW;

    public WebDavServiceImpl(InitParams params, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) throws Exception {
        ValueParam pUpdatePolicy;
        ValueParam pDefFileMimeType;
        ValueParam pDefFileNodeType;
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
        this.nullResourceLocks = new NullResourceLocksHolder();
        ValueParam pDefFolderNodeType = params.getValueParam(INIT_PARAM_DEF_FOLDER_NODE_TYPE);
        if (pDefFolderNodeType != null) {
            this.defaultFolderNodeType = pDefFolderNodeType.getValue();
            log.info((Object)("def-folder-node-type = " + this.defaultFolderNodeType));
        }
        if ((pDefFileNodeType = params.getValueParam(INIT_PARAM_DEF_FILE_NODE_TYPE)) != null) {
            this.defaultFileNodeType = pDefFileNodeType.getValue();
            log.info((Object)("def-file-node-type = " + this.defaultFileNodeType));
        }
        if ((pDefFileMimeType = params.getValueParam(INIT_PARAM_DEF_FILE_MIME_TYPE)) != null) {
            this.defaultFileMimeType = pDefFileMimeType.getValue();
            log.info((Object)("def-file-mimetype = " + this.defaultFileMimeType));
        }
        if ((pUpdatePolicy = params.getValueParam(INIT_PARAM_UPDATE_POLICY)) != null) {
            this.updatePolicyType = pUpdatePolicy.getValue();
            log.info((Object)("update-policy = " + this.updatePolicyType));
        }
    }

    @Override
    @CHECKIN
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkin(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("CHECKIN " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new CheckInCommand().checkIn(session, this.path(repoPath));
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @CHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("CHECKOUT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new CheckOutCommand().checkout(session, this.path(repoPath));
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @COPY
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response copy(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("COPY " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session;
            boolean overwrite;
            String serverURI = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).build(new Object[0]).toString();
            destinationHeader = TextUtil.unescape(destinationHeader, '%');
            if (!destinationHeader.startsWith(serverURI)) {
                return Response.status((int)502).build();
            }
            String srcWorkspace = this.workspaceName(repoPath);
            String srcNodePath = this.path(repoPath);
            String destPath = destinationHeader.substring(serverURI.length() + 1);
            String destWorkspace = this.workspaceName(destPath);
            String destNodePath = this.path(destPath);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Depth depth = new Depth(depthHeader);
            boolean bl = overwrite = overwriteHeader != null && overwriteHeader.equalsIgnoreCase("T");
            if (overwrite) {
                this.delete(repoName, destPath, lockTokenHeader, ifHeader);
            } else {
                session = this.session(repoName, this.workspaceName(repoPath), null);
                String uri = serverURI + "/" + srcWorkspace;
                Response prpfind = new PropFindCommand().propfind(session, destNodePath, body, depth.getIntValue(), uri);
                if (prpfind.getStatus() != 404) {
                    return Response.status((int)412).build();
                }
            }
            if (depth.getStringValue().equalsIgnoreCase("infinity")) {
                if (srcWorkspace.equals(destWorkspace)) {
                    session = this.session(repoName, destWorkspace, lockTokens);
                    return new CopyCommand().copy(session, srcNodePath, destNodePath);
                }
                Session destSession = this.session(repoName, destWorkspace, lockTokens);
                return new CopyCommand().copy(destSession, srcWorkspace, srcNodePath, destNodePath);
            }
            if (depth.getIntValue() == 0) {
                int nodeNameStart = srcNodePath.lastIndexOf(47) + 1;
                String nodeName = srcNodePath.substring(nodeNameStart);
                Session session2 = this.session(repoName, destWorkspace, lockTokens);
                return new MkColCommand(this.nullResourceLocks).mkCol(session2, destNodePath + "/" + nodeName, this.defaultFolderNodeType, null, lockTokens);
            }
            return Response.status((int)400).build();
        }
        catch (PreconditionException exc) {
            return Response.status((int)400).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @DELETE
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response delete(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("DELETE " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            if (lockTokenHeader != null) {
                lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1);
            }
            return new DeleteCommand().delete(session, this.path(repoPath), lockTokenHeader);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @GET
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response get(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Range") String rangeHeader, @QueryParam(value="version") String version, @Context UriInfo uriInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            ArrayList<Range> ranges = new ArrayList<Range>();
            if (rangeHeader != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)rangeHeader);
                }
                if (rangeHeader.startsWith("bytes=")) {
                    String[] tokens;
                    String rangeString = rangeHeader.substring(rangeHeader.indexOf("=") + 1);
                    for (String token : tokens = rangeString.split(",")) {
                        Range range = new Range();
                        int dash = (token = token.trim()).indexOf("-");
                        if (dash == -1) {
                            return Response.status((int)416).build();
                        }
                        if (dash == 0) {
                            range.setStart(Long.parseLong(token));
                            range.setEnd(-1L);
                        } else if (dash > 0) {
                            range.setStart(Long.parseLong(token.substring(0, dash)));
                            if (dash < token.length() - 1) {
                                range.setEnd(Long.parseLong(token.substring(dash + 1, token.length())));
                            } else {
                                range.setEnd(-1L);
                            }
                        }
                        ranges.add(range);
                    }
                }
            }
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new GetCommand().get(session, this.path(repoPath), version, uri, ranges);
        }
        catch (PathNotFoundException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @HEAD
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response head(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HEAD " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new HeadCommand().head(session, this.path(repoPath), uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @LOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response lock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("LOCK " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new LockCommand(this.nullResourceLocks).lock(session, this.path(repoPath), body, new Depth(depthHeader), "86400");
        }
        catch (PreconditionException exc) {
            log.error((Object)("PreconditionException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)412).build();
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @UNLOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response unlock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("UNLOCK " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            return new UnLockCommand(this.nullResourceLocks).unLock(session, this.path(repoPath), tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @MKCOL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response mkcol(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="Content-NodeType") String nodeTypeHeader, @HeaderParam(value="Content-MixinTypes") List<String> mixinTypesHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MKCOL " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            String nodeType = NodeTypeUtil.getFileNodeType(nodeTypeHeader);
            if (nodeType == null) {
                nodeType = this.defaultFolderNodeType;
            }
            return new MkColCommand(this.nullResourceLocks).mkCol(session, this.path(repoPath), nodeType, NodeTypeUtil.getMixinTypes(mixinTypesHeader), tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @MOVE
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response move(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MOVE " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session;
            boolean overwrite;
            String serverURI = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).build(new Object[0]).toString();
            destinationHeader = TextUtil.unescape(destinationHeader, '%');
            if (!destinationHeader.startsWith(serverURI)) {
                return Response.status((int)502).build();
            }
            String destPath = destinationHeader.substring(serverURI.length() + 1);
            String destWorkspace = this.workspaceName(destPath);
            String destNodePath = this.path(destPath);
            String srcWorkspace = this.workspaceName(repoPath);
            String srcNodePath = this.path(repoPath);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Depth depth = new Depth(depthHeader);
            boolean bl = overwrite = overwriteHeader != null && overwriteHeader.equalsIgnoreCase("T");
            if (overwrite) {
                this.delete(repoName, destPath, lockTokenHeader, ifHeader);
            } else {
                session = this.session(repoName, this.workspaceName(repoPath), null);
                String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
                Response prpfind = new PropFindCommand().propfind(session, destNodePath, body, depth.getIntValue(), uri);
                if (prpfind.getStatus() != 404) {
                    return Response.status((int)412).build();
                }
            }
            if (depth.getStringValue().equalsIgnoreCase("Infinity")) {
                if (srcWorkspace.equals(destWorkspace)) {
                    session = this.session(repoName, srcWorkspace, lockTokens);
                    return new MoveCommand().move(session, srcNodePath, destNodePath);
                }
                Session srcSession = this.session(repoName, srcWorkspace, lockTokens);
                Session destSession = this.session(repoName, destWorkspace, lockTokens);
                return new MoveCommand().move(srcSession, destSession, srcNodePath, destNodePath);
            }
            return Response.status((int)400).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @OPTIONS
    @Path(value="/{repoName}/{path:.*}/")
    public Response options(@PathParam(value="path") String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OPTIONS " + path));
        }
        String DASL_VALUE = "<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>";
        return Response.ok().header("Allow", (Object)ALLOW).header("DAV", (Object)"1, 2, ordered-collections").header("DASL", (Object)DASL_VALUE).header("MS-Author-Via", (Object)"DAV").build();
    }

    @Override
    @ORDERPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response order(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ORDERPATCH " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new OrderPatchCommand().orderPatch(session, this.path(repoPath), body, uri);
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @PROPFIND
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response propfind(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PROPFIND " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            Depth depth = new Depth(depthHeader);
            return new PropFindCommand().propfind(session, this.path(repoPath), body, depth.getIntValue(), uri);
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).build();
        }
        catch (PreconditionException exc) {
            return Response.status((int)400).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @PROPPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response proppatch(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PROPPATCH " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new PropPatchCommand(this.nullResourceLocks).propPatch(session, this.path(repoPath), body, lockTokens, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspace. " + exc.getMessage()));
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @PUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response put(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="File-NodeType") String fileNodeTypeHeader, @HeaderParam(value="Content-NodeType") String contentNodeTypeHeader, @HeaderParam(value="Content-MixinTypes") List<String> mixinTypes, @HeaderParam(value="Content-Type") String mimeType, InputStream inputStream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PUT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            String fileNodeType = NodeTypeUtil.getFileNodeType(fileNodeTypeHeader);
            if (fileNodeType == null) {
                fileNodeType = this.defaultFileNodeType;
            }
            String contentNodeType = NodeTypeUtil.getContentNodeType(contentNodeTypeHeader);
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            NodeType nodeType = ntm.getNodeType(contentNodeType);
            NodeTypeUtil.checkContentResourceType(nodeType);
            if (mimeType == null) {
                MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
                mimeTypeResolver.setDefaultMimeType(this.defaultFileMimeType);
                mimeType = mimeTypeResolver.getMimeType(TextUtil.nameOnly(repoPath));
            }
            return new PutCommand(this.nullResourceLocks).put(session, this.path(repoPath), inputStream, fileNodeType, contentNodeType, NodeTypeUtil.getMixinTypes(mixinTypes), mimeType, this.updatePolicyType, tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (NoSuchNodeTypeException exc) {
            log.error((Object)("NoSuchNodeTypeException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)400).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @REPORT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response report(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REPORT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Depth depth = new Depth(depthHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new ReportCommand().report(session, this.path(repoPath), body, depth, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @SEARCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response search(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SEARCH " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new SearchCommand().search(session, body, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @UNCHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response uncheckout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("UNCHECKOUT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new UnCheckOutCommand().uncheckout(session, this.path(repoPath));
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    @Override
    @VERSIONCONTROL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response versionControl(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug((Object)("VERSION-CONTROL " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
        return new VersionControlCommand().versionControl(session, this.path(repoPath));
    }

    protected Session session(String repoName, String wsName, List<String> lockTokens) throws Exception {
        ManageableRepository repo = this.repositoryService.getRepository(repoName);
        SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        Session session = sp.getSession(wsName, repo);
        if (lockTokens != null) {
            int i;
            String[] presentLockTokens = session.getLockTokens();
            ArrayList<String> presentLockTokensList = new ArrayList<String>();
            for (i = 0; i < presentLockTokens.length; ++i) {
                presentLockTokensList.add(presentLockTokens[i]);
            }
            for (i = 0; i < lockTokens.size(); ++i) {
                String lockToken = lockTokens.get(i);
                if (presentLockTokensList.contains(lockToken)) continue;
                session.addLockToken(lockToken);
            }
        }
        return session;
    }

    protected String workspaceName(String repoPath) {
        return repoPath.split("/")[0];
    }

    protected String normalizePath(String repoPath) {
        if (repoPath.length() > 0 && repoPath.endsWith("/")) {
            return repoPath.substring(0, repoPath.length() - 1);
        }
        return repoPath;
    }

    protected String path(String repoPath) {
        String path = repoPath.substring(this.workspaceName(repoPath).length());
        if (!"".equals(path)) {
            return path;
        }
        return "/";
    }

    protected List<String> lockTokens(String lockTokenHeader, String ifHeader) {
        ArrayList<String> lockTokens = new ArrayList<String>();
        if (lockTokenHeader != null) {
            if ((lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1)).contains("opaquelocktoken")) {
                lockTokenHeader = lockTokenHeader.split(":")[1];
            }
            lockTokens.add(lockTokenHeader);
        }
        if (ifHeader != null) {
            String headerLockToken = ifHeader.substring(ifHeader.indexOf("("));
            headerLockToken = headerLockToken.substring(2, headerLockToken.length() - 2);
            lockTokens.add(headerLockToken);
        }
        return lockTokens;
    }

    static {
        StringBuffer sb = new StringBuffer();
        for (Method m : WebDavServiceImpl.class.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                HttpMethod ma = null;
                ma = a.annotationType().getAnnotation(HttpMethod.class);
                if (ma == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ma.value());
            }
        }
        ALLOW = sb.toString();
    }
}

