/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ResourceUtil {
    private static Log log = ExoLogger.getLogger(ResourceUtil.class);

    private ResourceUtil() {
    }

    public static boolean isFile(Node node) {
        try {
            if (!node.isNodeType("nt:file")) {
                return false;
            }
            return node.getNode("jcr:content").isNodeType("nt:resource");
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
    }

    public static boolean isVersion(Node node) {
        try {
            return node.isNodeType("nt:version");
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
    }

    public static boolean isVersioned(Node node) {
        try {
            return node.isNodeType("mix:versionable");
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
    }
}

