/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import org.exoplatform.services.jcr.webdav.PreconditionException;

public class Depth {
    public static final String INFINITY_NAME = "Infinity";
    public static final int INFINITY_VALUE = -1;
    private int intValue;
    private String stringValue;

    public Depth(String strValue) throws PreconditionException {
        if (strValue == null || strValue.equalsIgnoreCase(INFINITY_NAME)) {
            this.intValue = -1;
            this.stringValue = INFINITY_NAME;
        } else {
            try {
                this.intValue = new Integer(strValue);
                if (this.intValue != 1 && this.intValue != 0 && this.intValue != -1) {
                    throw new PreconditionException("Invalid depth value " + strValue);
                }
                this.stringValue = strValue;
            }
            catch (NumberFormatException e) {
                throw new PreconditionException("Invalid depth value " + strValue);
            }
        }
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }
}

