/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.order.OrderMember;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderPatchCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.OrderPatchCommand");

    public Response orderPatch(Session session, String path, HierarchicalProperty body, String baseURI) {
        try {
            Node node = (Node)session.getItem(path);
            List<OrderMember> members = this.getMembers(body);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            if (this.doOrder(node, members)) {
                return Response.ok().build();
            }
            OrderPatchResponseEntity orderPatchEntity = new OrderPatchResponseEntity(nsContext, uri, node, members);
            return Response.status((int)207).entity((Object)orderPatchEntity).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    protected List<OrderMember> getMembers(HierarchicalProperty body) {
        ArrayList<OrderMember> members = new ArrayList<OrderMember>();
        List childs = body.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            OrderMember member = new OrderMember((HierarchicalProperty)childs.get(i));
            members.add(member);
        }
        return members;
    }

    protected boolean doOrder(Node parentNode, List<OrderMember> members) {
        boolean success = true;
        for (int i = 0; i < members.size(); ++i) {
            OrderMember member = members.get(i);
            int status = 200;
            try {
                parentNode.getSession().refresh(false);
                String positionedNodeName = null;
                if (!parentNode.hasNode(member.getSegment())) {
                    throw new PathNotFoundException();
                }
                if (!new QName("DAV:", "last").equals(member.getPosition())) {
                    NodeIterator nodeIter = parentNode.getNodes();
                    boolean finded = false;
                    while (nodeIter.hasNext()) {
                        Node curNode = nodeIter.nextNode();
                        if (new QName("DAV:", "first").equals(member.getPosition())) {
                            positionedNodeName = curNode.getName();
                            finded = true;
                            break;
                        }
                        if (new QName("DAV:", "before").equals(member.getPosition()) && curNode.getName().equals(member.getPositionSegment())) {
                            positionedNodeName = curNode.getName();
                            finded = true;
                            break;
                        }
                        if (!new QName("DAV:", "after").equals(member.getPosition()) || !curNode.getName().equals(member.getPositionSegment())) continue;
                        if (nodeIter.hasNext()) {
                            positionedNodeName = nodeIter.nextNode().getName();
                        }
                        finded = true;
                        break;
                    }
                    if (!finded) {
                        throw new AccessDeniedException();
                    }
                }
                parentNode.getSession().refresh(false);
                parentNode.orderBefore(member.getSegment(), positionedNodeName);
                parentNode.getSession().save();
            }
            catch (LockException exc) {
                status = 423;
            }
            catch (PathNotFoundException exc) {
                status = 403;
            }
            catch (AccessDeniedException exc) {
                status = 403;
            }
            catch (RepositoryException exc) {
                log.error((Object)exc.getMessage(), (Throwable)exc);
                status = 500;
            }
            member.setStatus(status);
            if (status == 200) continue;
            success = false;
        }
        return success;
    }
}

