/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.security.AccessControlException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.Response;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.webdav.command.acl.ACLProperties;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;

public class AclCommand {
    private static Log log = ExoLogger.getLogger(AclCommand.class);

    public Response acl(Session session, String path, HierarchicalProperty requestBody) {
        try {
            boolean nodeIsNotCheckedOut;
            NodeImpl node = (NodeImpl)session.getItem(path);
            boolean isSessionToBeSaved = false;
            boolean bl = nodeIsNotCheckedOut = node.isNodeType("mix:versionable") && !node.isCheckedOut();
            if (!node.isNodeType("exo:owneable")) {
                if (nodeIsNotCheckedOut) {
                    node.checkout();
                }
                node.addMixin("exo:owneable");
                isSessionToBeSaved = true;
            }
            if (!node.isNodeType("exo:privilegeable")) {
                if (nodeIsNotCheckedOut) {
                    node.checkout();
                }
                node.addMixin("exo:privilegeable");
                isSessionToBeSaved = true;
            }
            if (isSessionToBeSaved) {
                session.save();
                if (nodeIsNotCheckedOut) {
                    node.checkin();
                    session.save();
                }
            }
            this.changeNodeACL(node, requestBody);
        }
        catch (PathNotFoundException e) {
            return Response.status((int)404).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.status((int)500).entity((Object)exc.getMessage()).build();
        }
        catch (AccessControlException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.status((int)403).entity((Object)exc.getMessage()).build();
        }
        catch (IllegalArgumentException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.status((int)400).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.status((int)400).build();
        }
        return Response.status((int)200).build();
    }

    private void changeNodeACL(NodeImpl node, HierarchicalProperty requestBody) throws AccessControlException, RepositoryException {
        HashMap<String, String[]> permissionsToGrant = new HashMap<String, String[]>();
        HashMap<String, String[]> permissionsToDeny = new HashMap<String, String[]>();
        for (HierarchicalProperty hierarchicalProperty : requestBody.getChildren()) {
            String principal;
            HierarchicalProperty principalProperty = hierarchicalProperty.getChild(ACLProperties.PRINCIPAL);
            if (principalProperty == null) {
                throw new IllegalArgumentException("Malformed ace element (seems that no principal element specified)");
            }
            if (principalProperty.getChild(ACLProperties.HREF) != null) {
                principal = principalProperty.getChild(ACLProperties.HREF).getValue();
            } else if (principalProperty.getChild(ACLProperties.ALL) != null) {
                principal = IdentityConstants.ANY;
            } else {
                throw new IllegalArgumentException("Malformed principal element");
            }
            HierarchicalProperty denyProperty = hierarchicalProperty.getChild(ACLProperties.DENY);
            HierarchicalProperty grantProperty = hierarchicalProperty.getChild(ACLProperties.GRANT);
            if (denyProperty == null && grantProperty == null) {
                throw new IllegalArgumentException("Malformed ace element (seems that no deny|grant element specified)");
            }
            if (denyProperty != null) {
                permissionsToDeny.put(principal, this.getPermissions(denyProperty));
            }
            if (grantProperty != null) {
                permissionsToGrant.put(principal, this.getPermissions(grantProperty));
            }
            if (permissionsToDeny.size() == 0 || permissionsToGrant.size() == 0) continue;
            for (String denyPermission : (String[])permissionsToDeny.get(principal)) {
                for (String grantPermission : (String[])permissionsToGrant.get(principal)) {
                    if (!denyPermission.equals(grantPermission)) continue;
                    throw new IllegalArgumentException("Malformed ace element (seems that a client is trying to grant and denay the same privilege in a single ace)");
                }
            }
        }
        if (permissionsToDeny.size() != 0) {
            for (Map.Entry entry : permissionsToDeny.entrySet()) {
                for (String p : (String[])entry.getValue()) {
                    node.removePermission((String)entry.getKey(), p);
                }
            }
            node.getSession().save();
        }
        if (permissionsToGrant.size() != 0) {
            for (Map.Entry entry : permissionsToGrant.entrySet()) {
                node.setPermission((String)entry.getKey(), (String[])entry.getValue());
            }
            node.getSession().save();
        }
    }

    private String[] getPermissions(HierarchicalProperty property) {
        HashSet<String> permissionsToBeChanged = new HashSet<String>();
        if (property.getChildren().size() == 0) {
            throw new IllegalArgumentException("Malformed grant|deny element (seems that no privilige is specified)");
        }
        for (HierarchicalProperty propertyRunner : property.getChildren()) {
            HierarchicalProperty permissionProperty;
            if (ACLProperties.PRIVILEGE.equals(propertyRunner.getName())) {
                if (propertyRunner.getChildren().size() > 1) {
                    throw new IllegalArgumentException("Malformed privilege name (element privilege must contain only one element)");
                }
                permissionProperty = propertyRunner.getChild(0);
            } else {
                permissionProperty = propertyRunner;
            }
            if (ACLProperties.READ.equals(permissionProperty.getName())) {
                permissionsToBeChanged.add("read");
                continue;
            }
            if (ACLProperties.WRITE.equals(permissionProperty.getName())) {
                permissionsToBeChanged.add("add_node");
                permissionsToBeChanged.add("set_property");
                permissionsToBeChanged.add("remove");
                continue;
            }
            if (ACLProperties.ALL.equals(permissionProperty.getName())) {
                permissionsToBeChanged.add("read");
                permissionsToBeChanged.add("add_node");
                permissionsToBeChanged.add("set_property");
                permissionsToBeChanged.add("remove");
                continue;
            }
            throw new IllegalArgumentException("Malformed privilege element (unsupported privilege name)");
        }
        return permissionsToBeChanged.toArray(new String[0]);
    }
}

