/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.Resource;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericResource
implements Resource {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.webdav.resource.GenericResource");
    protected final URI identifier;
    protected final int type;
    protected final WebDavNamespaceContext namespaceContext;
    protected static final Set<QName> PRESET_PROP = new HashSet<QName>();

    public GenericResource(int type, URI identifier, WebDavNamespaceContext namespaceContext) {
        this.type = type;
        this.identifier = identifier;
        this.namespaceContext = namespaceContext;
    }

    @Override
    public final URI getIdentifier() {
        return this.identifier;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public Set<HierarchicalProperty> getProperties(boolean namesOnly) throws RepositoryException {
        HashSet<HierarchicalProperty> props = new HashSet<HierarchicalProperty>();
        for (QName propertyName : PRESET_PROP) {
            try {
                props.add(namesOnly ? new HierarchicalProperty(propertyName) : this.getProperty(propertyName));
            }
            catch (Exception exc) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("An exception occurred: " + exc.getMessage()));
            }
        }
        return props;
    }

    @Override
    public final WebDavNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public static HierarchicalProperty lockDiscovery(String token, String lockOwner, String timeOut) {
        HierarchicalProperty lockDiscovery = new HierarchicalProperty(new QName("DAV:", "lockdiscovery"));
        HierarchicalProperty activeLock = lockDiscovery.addChild(new HierarchicalProperty(new QName("DAV:", "activelock")));
        HierarchicalProperty lockType = activeLock.addChild(new HierarchicalProperty(new QName("DAV:", "locktype")));
        lockType.addChild(new HierarchicalProperty(new QName("DAV:", "write")));
        HierarchicalProperty lockScope = activeLock.addChild(new HierarchicalProperty(new QName("DAV:", "lockscope")));
        lockScope.addChild(new HierarchicalProperty(new QName("DAV:", "exclusive")));
        HierarchicalProperty depth = activeLock.addChild(new HierarchicalProperty(new QName("DAV:", "depth")));
        depth.setValue("Infinity");
        if (lockOwner != null) {
            HierarchicalProperty owner = activeLock.addChild(new HierarchicalProperty(new QName("DAV:", "owner")));
            owner.setValue(lockOwner);
        }
        HierarchicalProperty timeout = activeLock.addChild(new HierarchicalProperty(new QName("DAV:", "timeout")));
        timeout.setValue("Second-" + timeOut);
        if (token != null) {
            HierarchicalProperty lockToken = activeLock.addChild(new HierarchicalProperty(new QName("DAV:", "locktoken")));
            HierarchicalProperty lockHref = lockToken.addChild(new HierarchicalProperty(new QName("DAV:", "href")));
            lockHref.setValue(token);
        }
        return lockDiscovery;
    }

    protected HierarchicalProperty supportedLock() {
        HierarchicalProperty supportedLock = new HierarchicalProperty(new QName("DAV:", "supportedlock"));
        HierarchicalProperty lockEntry = new HierarchicalProperty(new QName("DAV:", "lockentry"));
        supportedLock.addChild(lockEntry);
        HierarchicalProperty lockScope = new HierarchicalProperty(new QName("DAV:", "lockscope"));
        lockScope.addChild(new HierarchicalProperty(new QName("DAV:", "exclusive")));
        lockEntry.addChild(lockScope);
        HierarchicalProperty lockType = new HierarchicalProperty(new QName("DAV:", "locktype"));
        lockType.addChild(new HierarchicalProperty(new QName("DAV:", "write")));
        lockEntry.addChild(lockType);
        return supportedLock;
    }

    protected HierarchicalProperty supportedMethodSet() {
        HierarchicalProperty supportedMethodProp = new HierarchicalProperty(SUPPORTEDMETHODSET);
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "PROPFIND");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "OPTIONS");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "DELETE");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "PROPPATCH");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "CHECKIN");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "CHECKOUT");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "REPORT");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "UNCHECKOUT");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "PUT");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "GET");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "HEAD");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "COPY");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "MOVE");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "VERSION-CONTROL");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "LABEL");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "LOCK");
        supportedMethodProp.addChild(new HierarchicalProperty(new QName("DAV:", "supported-method"))).setAttribute("name", "UNLOCK");
        return supportedMethodProp;
    }

    static {
        PRESET_PROP.add(DISPLAYNAME);
        PRESET_PROP.add(RESOURCETYPE);
        PRESET_PROP.add(CREATIONDATE);
    }
}

