/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.core.MediaType;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavServiceInitParams {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.WebDavServiceInitParams");
    private String defaultFolderNodeType = "nt:folder";
    private String defaultFileNodeType = "nt:file";
    private String defaultFileMimeType = "application/octet-stream";
    private String defaultUpdatePolicyType = "create-version";
    private String defaultAutoVersionType = "checkout-checkin";
    private Map<String, String> xsltParams = new HashMap<String, String>();
    private Set<String> untrustedUserAgents = new HashSet<String>();
    private Set<String> allowedFileNodeTypes = new HashSet<String>();
    private Set<String> allowedFolderNodeTypes = new HashSet<String>();
    private Map<MediaType, String> cacheControlMap = new HashMap<MediaType, String>();

    public WebDavServiceInitParams() {
        this.allowedFileNodeTypes.add("nt:file");
        this.allowedFolderNodeTypes.add("nt:folder");
    }

    public WebDavServiceInitParams(InitParams params) {
        this();
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        Iterator valueParamIterator = params.getValueParamIterator();
        while (valueParamIterator.hasNext()) {
            ValueParam valueParam = (ValueParam)valueParamIterator.next();
            parametersMap.put(valueParam.getName(), valueParam.getValue());
        }
        Iterator valuesParamIterator = params.getValuesParamIterator();
        while (valuesParamIterator.hasNext()) {
            ValuesParam valuesParam = (ValuesParam)valuesParamIterator.next();
            ArrayList values = valuesParam.getValues();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < values.size(); ++i) {
                sb.append((String)values.get(i));
                sb.append(',');
            }
            parametersMap.put(valuesParam.getName(), sb.toString());
        }
        this.processParametersMap(parametersMap);
    }

    public WebDavServiceInitParams(Map<String, String> params) {
        this();
        this.processParametersMap(params);
    }

    private void processParametersMap(Map<String, String> parameters) {
        ParametersMapProcessor pmp = new ParametersMapProcessor(parameters);
        pmp.processSingleParameter(this.defaultFolderNodeType, "def-folder-node-type");
        pmp.processSingleParameter(this.defaultFileNodeType, "def-file-node-type");
        pmp.processSingleParameter(this.defaultFileMimeType, "def-file-mimetype");
        pmp.processSingleParameter(this.defaultUpdatePolicyType, "update-policy");
        pmp.processSingleParameter(this.defaultAutoVersionType, "auto-version");
        pmp.processMultiParameter(this.untrustedUserAgents, "untrusted-user-agents");
        pmp.processMultiParameter(this.allowedFileNodeTypes, "allowed-file-node-types");
        pmp.processMultiParameter(this.allowedFolderNodeTypes, "allowed-folder-node-types");
        pmp.processSingleParameterToMap(this.xsltParams, "file-icon-path");
        pmp.processSingleParameterToMap(this.xsltParams, "folder-icon-path");
        pmp.processCacheControlParameter();
    }

    public String getDefaultFolderNodeType() {
        return this.defaultFolderNodeType;
    }

    public String getDefaultFileNodeType() {
        return this.defaultFileNodeType;
    }

    public String getDefaultFileMimeType() {
        return this.defaultFileMimeType;
    }

    public String getDefaultUpdatePolicyType() {
        return this.defaultUpdatePolicyType;
    }

    public String getDefaultAutoVersionType() {
        return this.defaultAutoVersionType;
    }

    public Map<String, String> getXsltParams() {
        return this.xsltParams;
    }

    public Set<String> getUntrustedUserAgents() {
        return this.untrustedUserAgents;
    }

    public Set<String> getAllowedFileNodeTypes() {
        return this.allowedFileNodeTypes;
    }

    public Set<String> getAllowedFolderNodeTypes() {
        return this.allowedFolderNodeTypes;
    }

    public Map<MediaType, String> getCacheControlMap() {
        return this.cacheControlMap;
    }

    public void setDefaultFolderNodeType(String defaultFolderNodeType) {
        this.defaultFolderNodeType = defaultFolderNodeType;
    }

    public void setDefaultFileNodeType(String defaultFileNodeType) {
        this.defaultFileNodeType = defaultFileNodeType;
    }

    public void setDefaultFileMimeType(String defaultFileMimeType) {
        this.defaultFileMimeType = defaultFileMimeType;
    }

    public void setDefaultUpdatePolicyType(String defaultUpdatePolicyType) {
        this.defaultUpdatePolicyType = defaultUpdatePolicyType;
    }

    public void setDefaultAutoVersionType(String defaultAutoVersionType) {
        this.defaultAutoVersionType = defaultAutoVersionType;
    }

    public void setXsltParams(Map<String, String> xsltParams) {
        this.xsltParams = xsltParams;
    }

    public void setUntrustedUserAgents(Set<String> untrustedUserAgents) {
        this.untrustedUserAgents = untrustedUserAgents;
    }

    public void setAllowedFileNodeTypes(Set<String> allowedFileNodeTypes) {
        this.allowedFileNodeTypes = allowedFileNodeTypes;
    }

    public void setAllowedFolderNodeTypes(Set<String> allowedFolderNodeTypes) {
        this.allowedFolderNodeTypes = allowedFolderNodeTypes;
    }

    public void setCacheControlMap(Map<MediaType, String> cacheControlMap) {
        this.cacheControlMap = cacheControlMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParametersMapProcessor {
        Map<String, String> parameters;

        public ParametersMapProcessor(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        private void processSingleParameterToMap(Map<String, String> parameterMap, String parameterName) {
            String paramValue = this.parameters.get(parameterName);
            if (paramValue != null) {
                parameterMap.put(parameterName, paramValue);
                log.info((Object)(parameterName + " = " + paramValue));
            }
        }

        private void processCacheControlParameter() {
            String paramValue = this.parameters.get("cache-control");
            if (paramValue != null) {
                try {
                    String[] elements;
                    for (String element : elements = paramValue.split(";")) {
                        String cacheValue = element.split(":")[1];
                        String keys = element.split(":")[0];
                        for (String key : keys.split(",")) {
                            MediaType mediaType = new MediaType(key.split("/")[0], key.split("/")[1]);
                            WebDavServiceInitParams.this.cacheControlMap.put(mediaType, cacheValue);
                        }
                    }
                }
                catch (PatternSyntaxException e) {
                    log.warn((Object)"Invalid cache-control parameter");
                }
                catch (UnsupportedOperationException e) {
                    log.warn((Object)"Invalid cache-control parameter");
                }
                catch (ClassCastException e) {
                    log.warn((Object)"Invalid cache-control parameter");
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)"Invalid cache-control parameter");
                }
            }
        }

        private void processSingleParameter(String parameter, String parameterName) {
            String paramValue = this.parameters.get(parameterName);
            if (paramValue != null) {
                parameter = paramValue;
                log.info((Object)(parameterName + " = " + parameter));
            }
        }

        private void processMultiParameter(Set<String> valuesSet, String parameterName) {
            String parameterMultivalue = this.parameters.get(parameterName);
            if (parameterMultivalue != null) {
                valuesSet.clear();
                for (String value : parameterMultivalue.split(",")) {
                    valuesSet.add(value.trim());
                    log.info((Object)(parameterName + " = " + value.trim()));
                }
            }
        }
    }
}

