/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.proppatch;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropPatchResponseEntity
implements StreamingOutput {
    private final WebDavNamespaceContext nsContext;
    private Node node;
    private final URI uri;
    private final List<HierarchicalProperty> setList;
    private final List<HierarchicalProperty> removeList;
    protected static final Set<QName> NON_REMOVING_PROPS = new HashSet<QName>();
    protected static final Set<QName> READ_ONLY_PROPS;

    public PropPatchResponseEntity(WebDavNamespaceContext nsContext, Node node, URI uri, List<HierarchicalProperty> setList, List<HierarchicalProperty> removeList) {
        this.nsContext = nsContext;
        this.node = node;
        this.uri = uri;
        this.setList = setList;
        this.removeList = removeList;
    }

    public void write(OutputStream outStream) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outStream, "UTF-8");
            xmlStreamWriter.setNamespaceContext(this.nsContext);
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            xmlStreamWriter.writeStartElement("DAV:", "response");
            xmlStreamWriter.writeStartElement("DAV:", "href");
            xmlStreamWriter.writeCharacters(this.uri.toASCIIString());
            xmlStreamWriter.writeEndElement();
            Map<String, Set<HierarchicalProperty>> propStats = this.getPropStat();
            PropertyWriteUtil.writePropStats(xmlStreamWriter, propStats);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exc) {
            throw new IOException(exc.getMessage(), exc);
        }
    }

    protected Map<String, Set<HierarchicalProperty>> getPropStat() {
        Set propSet;
        HierarchicalProperty jcrContentProp;
        Set propSet2;
        Node content;
        String statname;
        int i;
        HashMap<String, Set<HierarchicalProperty>> propStats = new HashMap<String, Set<HierarchicalProperty>>();
        for (i = 0; i < this.setList.size(); ++i) {
            HierarchicalProperty setProperty = this.setList.get(i);
            statname = WebDavConst.getStatusDescription(200);
            try {
                if (setProperty.getStringName().equals("jcr:content")) {
                    for (HierarchicalProperty child : setProperty.getChildren()) {
                        if (!child.getChildren().isEmpty()) continue;
                        if (this.node.isNodeType("mix:versionable") && !this.node.isCheckedOut()) {
                            this.node.checkout();
                            this.node.save();
                        }
                        if (!propStats.containsKey(statname = this.setProperty(content = this.getContentNode(), child))) {
                            propStats.put(statname, new HashSet());
                        }
                        propSet2 = (Set)propStats.get(statname);
                        jcrContentProp = new HierarchicalProperty(PropertyConstants.JCR_CONTENT);
                        jcrContentProp.addChild(new HierarchicalProperty(child.getName()));
                        propSet2.add(jcrContentProp);
                    }
                    continue;
                }
                statname = this.setProperty(this.node, setProperty);
                if (!propStats.containsKey(statname)) {
                    propStats.put(statname, new HashSet());
                }
                propSet = (Set)propStats.get(statname);
                propSet.add(new HierarchicalProperty(setProperty.getName()));
                continue;
            }
            catch (RepositoryException e) {
                statname = WebDavConst.getStatusDescription(409);
            }
        }
        for (i = 0; i < this.removeList.size(); ++i) {
            HierarchicalProperty removeProperty = this.removeList.get(i);
            statname = WebDavConst.getStatusDescription(200);
            if (NON_REMOVING_PROPS.contains(removeProperty.getName())) {
                statname = WebDavConst.getStatusDescription(409);
                if (!propStats.containsKey(statname)) {
                    propStats.put(statname, new HashSet());
                }
                propSet = (Set)propStats.get(statname);
                propSet.add(new HierarchicalProperty(removeProperty.getName()));
                continue;
            }
            if (removeProperty.getStringName().equals("jcr:content")) {
                for (HierarchicalProperty child : removeProperty.getChildren()) {
                    try {
                        content = this.getContentNode();
                        statname = this.removeProperty(content, child);
                        if (!propStats.containsKey(statname)) {
                            propStats.put(statname, new HashSet());
                        }
                        propSet2 = (Set)propStats.get(statname);
                        jcrContentProp = new HierarchicalProperty(new QName("jcr:content"));
                        jcrContentProp.addChild(new HierarchicalProperty(child.getName()));
                        propSet2.add(jcrContentProp);
                    }
                    catch (RepositoryException e) {
                        statname = WebDavConst.getStatusDescription(409);
                    }
                }
                continue;
            }
            statname = this.removeProperty(this.node, removeProperty);
            if (!propStats.containsKey(statname)) {
                propStats.put(statname, new HashSet());
            }
            propSet = (Set)propStats.get(statname);
            propSet.add(new HierarchicalProperty(removeProperty.getName()));
        }
        return propStats;
    }

    public Node getContentNode() throws RepositoryException {
        return this.node.getNode("jcr:content");
    }

    private String setProperty(Node node, HierarchicalProperty property) {
        String propertyName = WebDavNamespaceContext.createName(property.getName());
        if (READ_ONLY_PROPS.contains(property.getName())) {
            return WebDavConst.getStatusDescription(409);
        }
        try {
            Workspace ws = node.getSession().getWorkspace();
            NodeTypeDataManager nodeTypeHolder = ((WorkspaceImpl)ws).getNodeTypesHolder();
            NodeData data = (NodeData)((NodeImpl)node).getData();
            InternalQName propName = ((SessionImpl)node.getSession()).getLocationFactory().parseJCRName(propertyName).getInternalName();
            PropertyDefinitionDatas propdefs = nodeTypeHolder.getPropertyDefinitions(propName, data.getPrimaryTypeName(), data.getMixinTypeNames());
            if (propdefs == null) {
                throw new RepositoryException();
            }
            PropertyDefinitionData propertyDefinitionData = propdefs.getAnyDefinition();
            if (propertyDefinitionData == null) {
                throw new RepositoryException();
            }
            boolean isMultiValued = propertyDefinitionData.isMultiple();
            if (node.isNodeType("mix:versionable") && !node.isCheckedOut()) {
                node.checkout();
                node.save();
            }
            if (!isMultiValued) {
                node.setProperty(propertyName, property.getValue());
            } else {
                String[] value = new String[]{property.getValue()};
                node.setProperty(propertyName, value);
            }
            node.save();
            return WebDavConst.getStatusDescription(200);
        }
        catch (AccessDeniedException e) {
            return WebDavConst.getStatusDescription(403);
        }
        catch (ItemNotFoundException e) {
            return WebDavConst.getStatusDescription(404);
        }
        catch (PathNotFoundException e) {
            return WebDavConst.getStatusDescription(404);
        }
        catch (RepositoryException e) {
            return WebDavConst.getStatusDescription(409);
        }
    }

    private String removeProperty(Node node, HierarchicalProperty property) {
        try {
            node.getProperty(property.getStringName()).remove();
            node.save();
            return WebDavConst.getStatusDescription(200);
        }
        catch (AccessDeniedException e) {
            return WebDavConst.getStatusDescription(403);
        }
        catch (ItemNotFoundException e) {
            return WebDavConst.getStatusDescription(404);
        }
        catch (PathNotFoundException e) {
            return WebDavConst.getStatusDescription(404);
        }
        catch (RepositoryException e) {
            return WebDavConst.getStatusDescription(409);
        }
    }

    static {
        NON_REMOVING_PROPS.add(PropertyConstants.CREATIONDATE);
        NON_REMOVING_PROPS.add(PropertyConstants.DISPLAYNAME);
        NON_REMOVING_PROPS.add(PropertyConstants.GETCONTENTLANGUAGE);
        NON_REMOVING_PROPS.add(PropertyConstants.GETCONTENTLENGTH);
        NON_REMOVING_PROPS.add(PropertyConstants.GETCONTENTTYPE);
        NON_REMOVING_PROPS.add(PropertyConstants.GETLASTMODIFIED);
        NON_REMOVING_PROPS.add(PropertyConstants.JCR_DATA);
        READ_ONLY_PROPS = new HashSet<QName>();
        READ_ONLY_PROPS.add(PropertyConstants.JCR_DATA);
    }
}

