/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ResourceUtil {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.ResourceUtil");

    private ResourceUtil() {
    }

    public static boolean isFile(Node node) {
        try {
            if (!node.isNodeType("nt:file")) {
                return false;
            }
            return node.getNode("jcr:content").isNodeType("nt:resource");
        }
        catch (RepositoryException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
    }

    public static boolean isVersion(Node node) {
        try {
            return node.isNodeType("nt:version");
        }
        catch (RepositoryException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
    }

    public static boolean isVersioned(Node node) {
        try {
            return node.isNodeType("mix:versionable");
        }
        catch (RepositoryException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
    }

    public static String generateEntityTag(Node node, String lastModifiedProperty) throws UnsupportedRepositoryOperationException, RepositoryException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        Date lastModifiedDate = dateFormat.parse(lastModifiedProperty);
        return ((NodeImpl)node).getIdentifier() + lastModifiedDate.getTime();
    }
}

