/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MoveCommand {
    private static CacheControl cacheControl = new CacheControl();
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.MoveCommand");
    private final UriBuilder uriBuilder;
    private final boolean itemExisted;

    public MoveCommand() {
        this.uriBuilder = null;
        this.itemExisted = false;
    }

    public MoveCommand(UriBuilder uriBuilder, boolean itemExisted) {
        this.uriBuilder = uriBuilder;
        this.itemExisted = itemExisted;
    }

    public Response move(Session session, String srcPath, String destPath) {
        try {
            session.move(srcPath, destPath);
            session.save();
            if (this.itemExisted) {
                return Response.status((int)204).cacheControl(cacheControl).build();
            }
            if (this.uriBuilder != null) {
                return Response.created((URI)this.uriBuilder.path(session.getWorkspace().getName()).path(destPath).build(new Object[0])).cacheControl(cacheControl).build();
            }
            return Response.status((int)201).cacheControl(cacheControl).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    public Response move(Session sourceSession, Session destSession, String srcPath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourceSession.getWorkspace().getName(), srcPath, destPath);
            sourceSession.getItem(srcPath).remove();
            sourceSession.save();
            if (this.itemExisted) {
                return Response.status((int)204).cacheControl(cacheControl).build();
            }
            if (this.uriBuilder != null) {
                return Response.created((URI)this.uriBuilder.path(destSession.getWorkspace().getName()).path(destPath).build(new Object[0])).cacheControl(cacheControl).build();
            }
            return Response.status((int)201).cacheControl(cacheControl).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    static {
        cacheControl.setNoCache(true);
    }
}

