/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.database.hsqldb.HSQLDBDatabase;
import org.flywaydb.database.hsqldb.HSQLDBSchema;

public class HSQLDBConnection
extends org.flywaydb.core.internal.database.base.Connection<HSQLDBDatabase> {
    HSQLDBConnection(HSQLDBDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = ((HSQLDBDatabase)this.database).getJdbcMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        return schema;
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((HSQLDBDatabase)this.database).quote(new String[]{schema}), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new HSQLDBSchema(this.jdbcTemplate, (HSQLDBDatabase)this.database, name);
    }
}

