/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFactory;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.fusesource.camel.component.sap.SAPDestinationEndpoint;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.SAPServerEndpoint;
import org.fusesource.camel.component.sap.model.rfc.DestinationData;
import org.fusesource.camel.component.sap.model.rfc.DestinationDataStore;
import org.fusesource.camel.component.sap.model.rfc.RepositoryData;
import org.fusesource.camel.component.sap.model.rfc.RepositoryDataStore;
import org.fusesource.camel.component.sap.model.rfc.RfcFactory;
import org.fusesource.camel.component.sap.model.rfc.ServerData;
import org.fusesource.camel.component.sap.model.rfc.ServerDataStore;
import org.fusesource.camel.component.sap.util.ComponentDestinationDataProvider;
import org.fusesource.camel.component.sap.util.ComponentServerDataProvider;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SAPComponent.class);
    protected DestinationDataStore destinationDataStore = RfcFactory.eINSTANCE.createDestinationDataStore();
    protected ServerDataStore serverDataStore = RfcFactory.eINSTANCE.createServerDataStore();
    protected RepositoryDataStore repositoryDataStore = RfcFactory.eINSTANCE.createRepositoryDataStore();
    protected Map<String, JCoServer> activeServers = new HashMap<String, JCoServer>();
    protected Map<String, JCoCustomRepository> repositories = new HashMap<String, JCoCustomRepository>();
    protected ServerErrorAndExceptionListener serverErrorAndExceptionListener = new ServerErrorAndExceptionListener();
    protected ServerStateChangedListener serverStateChangedListener = new ServerStateChangedListener();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SAPEndpoint endpoint;
        String[] urlComponents = remaining.split(":");
        if (urlComponents.length != 3) {
            throw new IllegalArgumentException("URI must be of the form: sap:[destination:<destinationName>|server:<serverName>]:<rfcName>");
        }
        if (urlComponents[0].equals("destination")) {
            parameters.put("destinationName", urlComponents[1]);
            parameters.put("rfcName", urlComponents[2]);
            endpoint = new SAPDestinationEndpoint(uri, this);
        } else if (urlComponents[0].equals("server")) {
            parameters.put("serverName", urlComponents[1]);
            parameters.put("rfcName", urlComponents[2]);
            endpoint = new SAPServerEndpoint(uri, this);
        } else {
            throw new IllegalArgumentException("Must specify 'client' or 'server' in URL");
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public void setDestinationDataStore(Map<String, DestinationData> destinationDataEntries) {
        this.destinationDataStore.getEntries().clear();
        this.destinationDataStore.getEntries().putAll(destinationDataEntries);
    }

    public Map<String, DestinationData> getDestinationDataStore() {
        return this.destinationDataStore.getEntries().map();
    }

    public void setServerDataStore(Map<String, ServerData> serverDataEntries) {
        this.serverDataStore.getEntries().clear();
        this.serverDataStore.getEntries().putAll(serverDataEntries);
    }

    public Map<String, ServerData> getServerDataStore() {
        return this.serverDataStore.getEntries().map();
    }

    public Map<String, RepositoryData> getRepositoryDataStore() {
        return this.repositoryDataStore.getEntries().map();
    }

    public void setRepositoryDataStore(Map<String, RepositoryData> repositoryDataEntries) {
        this.repositoryDataStore.getEntries().clear();
        this.repositoryDataStore.getEntries().putAll(repositoryDataEntries);
    }

    protected synchronized JCoServer getServer(String serverName) throws Exception {
        JCoServer server = this.activeServers.get(serverName);
        if (server == null) {
            server = JCoServerFactory.getServer((String)serverName);
            server.setCallHandlerFactory((JCoServerCallHandlerFactory)new FunctionHandlerFactory());
            server.addServerExceptionListener((JCoServerExceptionListener)this.serverErrorAndExceptionListener);
            server.addServerErrorListener((JCoServerErrorListener)this.serverErrorAndExceptionListener);
            server.addServerStateChangedListener((JCoServerStateChangedListener)this.serverStateChangedListener);
            JCoCustomRepository repository = this.getRepository(serverName);
            if (repository != null) {
                String repositoryDestination = server.getRepositoryDestination();
                if (repositoryDestination != null) {
                    try {
                        repository.setDestination(JCoDestinationManager.getDestination((String)repositoryDestination));
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to set destination on custom repository '" + serverName + "'", (Throwable)e);
                    }
                }
                server.setRepository((JCoRepository)repository);
            }
            this.activeServers.put(serverName, server);
            if (this.isStarted()) {
                server.start();
                LOG.debug("Started server " + server.getProgramID());
            }
        }
        return server;
    }

    protected FunctionHandlerFactory getServerHandlerFactory(String serverName) throws Exception {
        JCoServer server = this.getServer(serverName);
        if (server == null) {
            return null;
        }
        return (FunctionHandlerFactory)server.getCallHandlerFactory();
    }

    protected synchronized JCoCustomRepository getRepository(String serverName) {
        RepositoryData repositoryData;
        JCoCustomRepository repository = this.repositories.get(serverName);
        if (repository == null && (repositoryData = this.repositoryDataStore.getEntries().get(serverName)) != null) {
            repository = RfcUtil.createRepository(serverName, repositoryData);
            this.repositories.put(serverName, repository);
        }
        return repository;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ComponentDestinationDataProvider.INSTANCE.addDestinationDataStore(this.destinationDataStore);
        ComponentServerDataProvider.INSTANCE.addServerDataStore(this.serverDataStore);
        for (JCoServer server : this.activeServers.values()) {
            server.start();
        }
    }

    protected void doStop() throws Exception {
        ComponentDestinationDataProvider.INSTANCE.removeDestinationDataStore(this.destinationDataStore);
        ComponentServerDataProvider.INSTANCE.removeServerDataStore(this.serverDataStore);
        super.doStop();
    }

    public class ServerStateChangedListener
    implements JCoServerStateChangedListener {
        public void serverStateChangeOccurred(JCoServer jcoServer, JCoServerState oldState, JCoServerState newState) {
            LOG.info(">>> Server state changed from " + oldState.toString() + " to " + newState.toString() + " on " + jcoServer.getProgramID());
        }
    }

    public class ServerErrorAndExceptionListener
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        public void serverExceptionOccurred(JCoServer jcoServer, String connectionId, JCoServerContextInfo serverContext, Exception exception) {
            LOG.warn(">>> Exception occured on " + jcoServer.getProgramID() + " connection " + connectionId, (Throwable)exception);
        }

        public void serverErrorOccurred(JCoServer jcoServer, String connectionId, JCoServerContextInfo serverContext, Error error) {
            LOG.warn(">>> Error occured on " + jcoServer.getProgramID() + " connection " + connectionId, (Throwable)error);
        }
    }

    class FunctionHandlerFactory
    implements JCoServerFunctionHandlerFactory {
        private Map<String, JCoServerFunctionHandler> callHandlers = new HashMap<String, JCoServerFunctionHandler>();
        private Map<String, SessionContext> statefulSessions = new HashMap<String, SessionContext>();

        FunctionHandlerFactory() {
        }

        public void registerHandler(String functionName, JCoServerFunctionHandler handler) {
            this.callHandlers.put(functionName, handler);
        }

        public JCoServerFunctionHandler unregisterHandler(String functionName) {
            return this.callHandlers.remove(functionName);
        }

        public void sessionClosed(JCoServerContext serverContext, String arg1, boolean arg2) {
            this.statefulSessions.remove(serverContext.getSessionID());
        }

        public JCoServerFunctionHandler getCallHandler(JCoServerContext serverContext, String functionName) {
            JCoServerFunctionHandler handler = this.callHandlers.get(functionName);
            return handler;
        }

        class SessionContext {
            Map<String, Object> cachedSessionData = new HashMap<String, Object>();

            SessionContext() {
            }
        }
    }
}

