/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.fusesource.camel.component.sap.SAPServerEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPConsumer
extends DefaultConsumer
implements JCoServerFunctionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SAPConsumer.class);
    Map<String, Object> sessionData = new HashMap<String, Object>();

    public SAPConsumer(SAPServerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public SAPServerEndpoint getEndpoint() {
        return (SAPServerEndpoint)super.getEndpoint();
    }

    public void setSessionData(Map<String, Object> sessionData) {
        this.sessionData = sessionData;
    }

    public void handleRequest(JCoServerContext serverContext, JCoFunction jcoFunction) throws AbapException, AbapClassException {
        block10: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handling request for RFC '{}'", (Object)jcoFunction.getName());
            }
            SAPServerEndpoint sapEndpoint = this.getEndpoint();
            Exchange exchange = this.getEndpoint().createExchange(sapEndpoint.getMep());
            Structure request = RfcUtil.getRequest(serverContext.getRepository(), jcoFunction.getName());
            RfcUtil.extractJCoParameterListsIntoRequest(jcoFunction, request);
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Request: " + (request == null ? request : RfcUtil.marshal(request)));
                }
                catch (IOException e) {
                    LOG.warn("Failed to log request", (Throwable)e);
                }
            }
            try {
                Message message = exchange.getIn();
                message.setHeader("sap.sessionData", this.sessionData);
                message.setBody((Object)request);
                this.getProcessor().process(exchange);
                if (!exchange.getPattern().isOutCapable()) break block10;
                message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
                Structure response = (Structure)message.getBody(Structure.class);
                if (LOG.isDebugEnabled()) {
                    try {
                        LOG.debug("Response: " + (response == null ? response : RfcUtil.marshal(response)));
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to log response", (Throwable)e);
                    }
                }
                RfcUtil.fillJCoParameterListsFromResponse(response, jcoFunction);
            }
            catch (IOException e) {
                this.getExceptionHandler().handleException("Failed to marshal request", (Throwable)e);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Failed to process request", (Throwable)e);
            }
        }
    }
}

