/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.fusesource.camel.component.sap.SAPComponent;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.SAPProducer;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPDestinationEndpoint
extends SAPEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SAPDestinationEndpoint.class);
    protected String destinationName;
    protected String rfcName;
    protected boolean transacted;
    protected JCoDestination destination;

    public SAPDestinationEndpoint() {
    }

    public SAPDestinationEndpoint(String endpointUri, SAPComponent component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public Producer createProducer() throws Exception {
        return new SAPProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Destination endpoints do not support consumers");
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    @Override
    public String getRfcName() {
        return this.rfcName;
    }

    @Override
    public void setRfcName(String rfcName) {
        this.rfcName = rfcName;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    @Override
    public Structure getRequest() throws Exception {
        return RfcUtil.getRequest(this.getDestination().getRepository(), this.getRfcName());
    }

    @Override
    public Structure getResponse() throws Exception {
        return RfcUtil.getResponse(this.getDestination().getRepository(), this.getRfcName());
    }

    protected JCoDestination getDestination() {
        if (this.destination == null) {
            try {
                this.destination = JCoDestinationManager.getDestination((String)this.destinationName);
            }
            catch (Exception e) {
                LOG.warn("Failed to get destination object for endpoint. This exception will be ignored.", (Throwable)e);
            }
        }
        return this.destination;
    }
}

