/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoDestination;
import org.apache.camel.Exchange;
import org.apache.camel.support.SynchronizationAdapter;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPDestinationTransaction
extends SynchronizationAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SAPDestinationTransaction.class);
    private String destinationName;
    private JCoDestination destination;

    public SAPDestinationTransaction(String destinationName, JCoDestination destination) {
        this.destinationName = destinationName;
        this.destination = destination;
    }

    public int hashCode() {
        return this.destinationName.hashCode();
    }

    public boolean equals(Object obj) {
        return this.destinationName.equals(obj);
    }

    public void begin() {
        RfcUtil.beginTransaction(this.destination);
        LOG.debug("Began SAP Transaction for destination '{}'", (Object)this.destinationName);
    }

    public void commit() throws Exception {
        RfcUtil.commitTransaction(this.destination);
        LOG.debug("Committed SAP Transaction for destination '{}'", (Object)this.destinationName);
    }

    public void rollback() throws Exception {
        RfcUtil.rollbackTransaction(this.destination);
        LOG.debug("Rolledback SAP Transaction for destination '{}'", (Object)this.destinationName);
    }

    public void onComplete(Exchange exchange) {
        try {
            this.commit();
        }
        catch (Exception e) {
            LOG.warn("Failed to commit SAP Transaction. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onFailure(Exchange exchange) {
        try {
            this.rollback();
        }
        catch (Exception e) {
            LOG.warn("Failed to rollback SAP Transaction. This exception will be ignored.", (Throwable)e);
        }
    }
}

