/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.Synchronization;
import org.fusesource.camel.component.sap.SAPDestinationEndpoint;
import org.fusesource.camel.component.sap.SAPDestinationTransaction;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SAPProducer.class);

    public SAPProducer(SAPEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public SAPProducer(SAPDestinationEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        this.checkIfTransacted(exchange);
        Structure request = (Structure)exchange.getIn().getBody(Structure.class);
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Calling '{}' RFC", (Object)this.getEndpoint().getRfcName());
                LOG.debug("Request: " + (request == null ? request : RfcUtil.marshal(request)));
            }
            catch (Exception e) {
                LOG.warn("Failed to log request", (Throwable)e);
            }
        }
        Structure response = RfcUtil.executeFunction(this.getEndpoint().getDestination(), this.getEndpoint().getRfcName(), request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response: " + (response == null ? response : RfcUtil.marshal(response)));
        }
        exchange.setOut(exchange.getIn().copy());
        exchange.getOut().setBody((Object)response);
    }

    public SAPDestinationEndpoint getEndpoint() {
        return (SAPDestinationEndpoint)super.getEndpoint();
    }

    protected void checkIfTransacted(Exchange exchange) {
        if (this.getEndpoint().isTransacted()) {
            SAPDestinationTransaction transaction = new SAPDestinationTransaction(this.getEndpoint().getDestinationName(), this.getEndpoint().getDestination());
            if (!exchange.getUnitOfWork().containsSynchronization((Synchronization)transaction)) {
                transaction.begin();
                exchange.getUnitOfWork().addSynchronization((Synchronization)transaction);
            }
        }
    }
}

