/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerFactory;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.fusesource.camel.component.sap.SAPComponent;
import org.fusesource.camel.component.sap.SAPConsumer;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPServerEndpoint
extends SAPEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SAPServerEndpoint.class);
    protected String serverName;
    protected JCoServer server;

    public SAPServerEndpoint() {
    }

    public SAPServerEndpoint(String endpointUri, SAPComponent component) {
        super(endpointUri, component);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public SAPComponent getComponent() {
        return (SAPComponent)super.getComponent();
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Server endpoints do not support producers");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SAPComponent.FunctionHandlerFactory handlerFactory = this.getComponent().getServerHandlerFactory(this.serverName);
        if (handlerFactory == null) {
            throw new IllegalStateException("Function Handler Factory for '" + this.serverName + "' missing.");
        }
        SAPConsumer consumer = new SAPConsumer(this, processor);
        handlerFactory.registerHandler(this.getRfcName(), consumer);
        return consumer;
    }

    @Override
    public Structure getRequest() throws Exception {
        return RfcUtil.getRequest(this.getServer().getRepository(), this.getRfcName());
    }

    @Override
    public Structure getResponse() throws Exception {
        return RfcUtil.getResponse(this.getServer().getRepository(), this.getRfcName());
    }

    protected JCoServer getServer() {
        if (this.server == null) {
            try {
                this.server = JCoServerFactory.getServer((String)this.serverName);
            }
            catch (JCoException e) {
                LOG.warn("Failed to get server object for endpoint. This exception will be ignored.", (Throwable)e);
            }
        }
        return this.server;
    }
}

