/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.model.rfc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataType implements Enumerator
{
    CHAR(0, "CHAR", "CHAR"),
    DATE(1, "DATE", "DATE"),
    BCD(2, "BCD", "BCD"),
    TIME(3, "TIME", "TIME"),
    BYTE(4, "BYTE", "BYTE"),
    NUM(6, "NUM", "NUM"),
    FLOAT(7, "FLOAT", "FLOAT"),
    INT(8, "INT", "INT"),
    INT2(9, "INT2", "INT2"),
    INT1(10, "INT1", "INT1"),
    STRUCTURE(17, "STRUCTURE", "STRUCTURE"),
    DECF16(23, "DECF16", "DECF16"),
    DECF34(24, "DECF34", "DECF34"),
    STRING(29, "STRING", "STRING"),
    XSTRING(30, "XSTRING", "XSTRING"),
    TABLE(99, "TABLE", "TABLE");

    public static final int CHAR_VALUE = 0;
    public static final int DATE_VALUE = 1;
    public static final int BCD_VALUE = 2;
    public static final int TIME_VALUE = 3;
    public static final int BYTE_VALUE = 4;
    public static final int NUM_VALUE = 6;
    public static final int FLOAT_VALUE = 7;
    public static final int INT_VALUE = 8;
    public static final int INT2_VALUE = 9;
    public static final int INT1_VALUE = 10;
    public static final int STRUCTURE_VALUE = 17;
    public static final int DECF16_VALUE = 23;
    public static final int DECF34_VALUE = 24;
    public static final int STRING_VALUE = 29;
    public static final int XSTRING_VALUE = 30;
    public static final int TABLE_VALUE = 99;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{CHAR, DATE, BCD, TIME, BYTE, NUM, FLOAT, INT, INT2, INT1, STRUCTURE, DECF16, DECF34, STRING, XSTRING, TABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 0: {
                return CHAR;
            }
            case 1: {
                return DATE;
            }
            case 2: {
                return BCD;
            }
            case 3: {
                return TIME;
            }
            case 4: {
                return BYTE;
            }
            case 6: {
                return NUM;
            }
            case 7: {
                return FLOAT;
            }
            case 8: {
                return INT;
            }
            case 9: {
                return INT2;
            }
            case 10: {
                return INT1;
            }
            case 17: {
                return STRUCTURE;
            }
            case 23: {
                return DECF16;
            }
            case 24: {
                return DECF34;
            }
            case 29: {
                return STRING;
            }
            case 30: {
                return XSTRING;
            }
            case 99: {
                return TABLE;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

