/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.model.rfc.impl;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.fusesource.camel.component.sap.model.rfc.RfcPackage;
import org.fusesource.camel.component.sap.model.rfc.Structure;

public class StructureImpl
extends EObjectImpl
implements Structure {
    private volatile transient EntrySet entrySet = null;
    private volatile transient KeySet keySet = null;
    private volatile transient Values values = null;

    protected StructureImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return RfcPackage.Literals.STRUCTURE;
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new IllegalArgumentException("The value is not of type: " + type + " but is : " + value.getClass().getCanonicalName());
    }

    @Override
    public int size() {
        return this.eClass().getFeatureCount();
    }

    @Override
    public boolean isEmpty() {
        return this.eClass().getFeatureCount() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String featureName = (String)key;
        return this.eClass().getEStructuralFeature(featureName) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (EStructuralFeature eFeature : this.eClass().getEStructuralFeatures()) {
            if (!this.eGet(eFeature).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String featureName = (String)key;
        EStructuralFeature eFeature = this.eClass().getEStructuralFeature(featureName);
        if (eFeature == null) {
            return null;
        }
        Object value = this.eGet(eFeature);
        if (value == null && eFeature instanceof EReference) {
            EClass eClass = ((EReference)eFeature).getEReferenceType();
            value = eClass.getEPackage().getEFactoryInstance().create(eClass);
            this.put(featureName, value);
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        EStructuralFeature eFeature = this.eClass().getEStructuralFeature(key);
        if (eFeature == null) {
            throw new IllegalArgumentException("Key '" + key + "' is not valid for this structure");
        }
        Object returnValue = this.eGet(eFeature);
        this.eSet(eFeature, value);
        return returnValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String featureName = (String)key;
        EStructuralFeature eFeature = this.eClass().getEStructuralFeature(featureName);
        if (eFeature == null) {
            return null;
        }
        Object returnValue = this.eGet(eFeature);
        this.eUnset(eFeature);
        return returnValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            Object value = m.get(string);
            this.put(string, value);
        }
    }

    @Override
    public void clear() {
        for (EStructuralFeature eFeature : this.eClass().getEStructuralFeatures()) {
            this.eUnset(eFeature);
        }
    }

    @Override
    public Set<String> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Object> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public static class Entry
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends FeatureIterator<Map.Entry<String, Object>> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            EStructuralFeature feature = this.nextEntry();
            Object value = StructureImpl.this.get(feature.getName());
            return new Entry(feature.getName(), value);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return StructureImpl.this.containsKey(e.getKey());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object value = StructureImpl.this.remove(e.getKey());
            return value != null;
        }

        @Override
        public int size() {
            return StructureImpl.this.size();
        }

        @Override
        public void clear() {
            StructureImpl.this.clear();
        }
    }

    private abstract class FeatureIterator<E>
    implements Iterator<E> {
        private final Iterator<EStructuralFeature> iterator;
        private EStructuralFeature current;

        public FeatureIterator() {
            this.iterator = StructureImpl.this.eClass().getEStructuralFeatures().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        EStructuralFeature nextEntry() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            String key = this.current.getName();
            this.current = null;
            StructureImpl.this.remove(key);
        }
    }

    private class KeyIterator
    extends FeatureIterator<String> {
        private KeyIterator() {
        }

        @Override
        public String next() {
            return this.nextEntry().getName();
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return StructureImpl.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return StructureImpl.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            if (StructureImpl.this.containsKey(key)) {
                StructureImpl.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            StructureImpl.this.clear();
        }
    }

    private class ValueIterator
    extends FeatureIterator<Object> {
        private ValueIterator() {
        }

        @Override
        public Object next() {
            EStructuralFeature feature = this.nextEntry();
            return StructureImpl.this.get(feature.getName());
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return StructureImpl.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return StructureImpl.this.containsValue(o);
        }

        @Override
        public void clear() {
            StructureImpl.this.clear();
        }
    }
}

