/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.util;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fusesource.camel.component.sap.model.rfc.DestinationData;
import org.fusesource.camel.component.sap.model.rfc.DestinationDataStore;
import org.fusesource.camel.component.sap.model.rfc.RfcPackage;
import org.fusesource.camel.component.sap.model.rfc.impl.DestinationDataStoreEntryImpl;

public class ComponentDestinationDataProvider
implements DestinationDataProvider {
    public static final ComponentDestinationDataProvider INSTANCE = new ComponentDestinationDataProvider();
    private final DestinationDataStoreListener destinationDataStoreListener = new DestinationDataStoreListener();
    protected DestinationDataEventListener destinationDataEventListener;
    Set<DestinationDataStore> stores = new HashSet<DestinationDataStore>();

    private ComponentDestinationDataProvider() {
        Environment.registerDestinationDataProvider((DestinationDataProvider)this);
    }

    public void addDestinationDataStore(DestinationDataStore store) {
        this.stores.add(store);
        store.eAdapters().add(this.destinationDataStoreListener);
        if (this.destinationDataEventListener == null) {
            return;
        }
        for (String destinationName : store.getEntries().keySet()) {
            this.destinationDataEventListener.updated(destinationName);
        }
    }

    public void removeDestinationDataStore(DestinationDataStore store) {
        this.stores.remove(store);
        store.eAdapters().remove(this.destinationDataStoreListener);
        for (String destinationName : store.getEntries().keySet()) {
            this.destinationDataEventListener.deleted(destinationName);
        }
    }

    public Properties getDestinationProperties(String destinationName) {
        for (DestinationDataStore store : this.stores) {
            DestinationData destinationData = store.getEntries().get(destinationName);
            if (destinationData == null) continue;
            Properties properties = new Properties();
            properties.putAll(destinationData.getEntries().map());
            return properties;
        }
        return null;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener destinationDataEventListener) {
        this.destinationDataEventListener = destinationDataEventListener;
    }

    public boolean supportsEvents() {
        return true;
    }

    public class DestinationDataListener
    extends EContentAdapter {
        private String destinationName;

        public DestinationDataListener(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public void notifyChanged(Notification msg) {
            switch (msg.getEventType()) {
                case 1: 
                case 3: 
                case 5: {
                    if (ComponentDestinationDataProvider.this.destinationDataEventListener == null) break;
                    ComponentDestinationDataProvider.this.destinationDataEventListener.updated(this.destinationName);
                    break;
                }
                case 4: 
                case 6: {
                    if (ComponentDestinationDataProvider.this.destinationDataEventListener == null) break;
                    ComponentDestinationDataProvider.this.destinationDataEventListener.deleted(this.destinationName);
                }
            }
            super.notifyChanged(msg);
        }
    }

    public class DestinationDataStoreListener
    extends EContentAdapter {
        @Override
        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == RfcPackage.Literals.DESTINATION_DATA_STORE__ENTRIES) {
                switch (msg.getEventType()) {
                    case 3: {
                        DestinationDataStoreEntryImpl entry = (DestinationDataStoreEntryImpl)msg.getNewValue();
                        this.addDestinationDataListener(entry.getKey(), entry.getValue());
                        if (ComponentDestinationDataProvider.this.destinationDataEventListener == null) break;
                        ComponentDestinationDataProvider.this.destinationDataEventListener.updated(entry.getKey());
                        break;
                    }
                    case 5: {
                        Collection entries = (Collection)msg.getNewValue();
                        for (DestinationDataStoreEntryImpl entry : entries) {
                            this.addDestinationDataListener(entry.getKey(), entry.getValue());
                            if (ComponentDestinationDataProvider.this.destinationDataEventListener == null) continue;
                            ComponentDestinationDataProvider.this.destinationDataEventListener.updated(entry.getKey());
                        }
                        break;
                    }
                    case 4: {
                        DestinationDataStoreEntryImpl entry = (DestinationDataStoreEntryImpl)msg.getOldValue();
                        this.removeDestinationDataListener(entry.getValue());
                        if (ComponentDestinationDataProvider.this.destinationDataEventListener == null) break;
                        ComponentDestinationDataProvider.this.destinationDataEventListener.deleted(entry.getKey());
                        break;
                    }
                    case 6: {
                        Collection entries = (Collection)msg.getOldValue();
                        for (DestinationDataStoreEntryImpl entry : entries) {
                            this.removeDestinationDataListener(entry.getValue());
                            if (ComponentDestinationDataProvider.this.destinationDataEventListener == null) continue;
                            ComponentDestinationDataProvider.this.destinationDataEventListener.deleted(entry.getKey());
                        }
                        break;
                    }
                }
            }
            super.notifyChanged(msg);
        }

        protected void addDestinationDataListener(String connectionName, Notifier notifier) {
            notifier.eAdapters().add(new DestinationDataListener(connectionName));
        }

        protected void removeDestinationDataListener(Notifier notifier) {
            HashSet<Adapter> listeners = new HashSet<Adapter>();
            for (Adapter adapter : notifier.eAdapters()) {
                if (!(adapter instanceof DestinationDataListener)) continue;
                listeners.add(adapter);
            }
            notifier.eAdapters().removeAll(listeners);
        }
    }
}

