/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.util;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fusesource.camel.component.sap.model.rfc.RfcPackage;
import org.fusesource.camel.component.sap.model.rfc.ServerData;
import org.fusesource.camel.component.sap.model.rfc.ServerDataStore;
import org.fusesource.camel.component.sap.model.rfc.impl.ServerDataStoreEntryImpl;

public class ComponentServerDataProvider
implements ServerDataProvider {
    public static final ComponentServerDataProvider INSTANCE = new ComponentServerDataProvider();
    private final ServerDataStoreListener serverDataStoreListener = new ServerDataStoreListener();
    protected ServerDataEventListener serverDataEventListener;
    Set<ServerDataStore> stores = new HashSet<ServerDataStore>();

    private ComponentServerDataProvider() {
        Environment.registerServerDataProvider((ServerDataProvider)this);
    }

    public void addServerDataStore(ServerDataStore store) {
        this.stores.add(store);
        store.eAdapters().add(this.serverDataStoreListener);
        if (this.serverDataEventListener == null) {
            return;
        }
        for (String serverName : store.getEntries().keySet()) {
            this.serverDataEventListener.updated(serverName);
        }
    }

    public void removeServerDataStore(ServerDataStore store) {
        this.stores.remove(store);
        store.eAdapters().remove(this.serverDataStoreListener);
        for (String serverName : store.getEntries().keySet()) {
            this.serverDataEventListener.deleted(serverName);
        }
    }

    public boolean supportsEvents() {
        return true;
    }

    public Properties getServerProperties(String serverName) {
        for (ServerDataStore store : this.stores) {
            ServerData serverData = store.getEntries().get(serverName);
            if (serverData == null) continue;
            Properties properties = new Properties();
            properties.putAll(serverData.getEntries().map());
            return properties;
        }
        return null;
    }

    public void setServerDataEventListener(ServerDataEventListener serverDataEventListener) {
        this.serverDataEventListener = serverDataEventListener;
    }

    public class ServerDataListener
    extends EContentAdapter {
        private String serverName;

        public ServerDataListener(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public void notifyChanged(Notification msg) {
            switch (msg.getEventType()) {
                case 1: 
                case 3: 
                case 5: {
                    if (ComponentServerDataProvider.this.serverDataEventListener == null) break;
                    ComponentServerDataProvider.this.serverDataEventListener.updated(this.serverName);
                    break;
                }
                case 4: 
                case 6: {
                    if (ComponentServerDataProvider.this.serverDataEventListener == null) break;
                    ComponentServerDataProvider.this.serverDataEventListener.deleted(this.serverName);
                }
            }
            super.notifyChanged(msg);
        }
    }

    public class ServerDataStoreListener
    extends EContentAdapter {
        @Override
        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == RfcPackage.Literals.SERVER_DATA_STORE__ENTRIES) {
                switch (msg.getEventType()) {
                    case 3: {
                        ServerDataStoreEntryImpl entry = (ServerDataStoreEntryImpl)msg.getNewValue();
                        this.addServerDataListener(entry.getKey(), entry.getValue());
                        if (ComponentServerDataProvider.this.serverDataEventListener == null) break;
                        ComponentServerDataProvider.this.serverDataEventListener.updated(entry.getKey());
                        break;
                    }
                    case 5: {
                        Collection entries = (Collection)msg.getNewValue();
                        for (ServerDataStoreEntryImpl entry : entries) {
                            this.addServerDataListener(entry.getKey(), entry.getValue());
                            if (ComponentServerDataProvider.this.serverDataEventListener == null) continue;
                            ComponentServerDataProvider.this.serverDataEventListener.updated(entry.getKey());
                        }
                        break;
                    }
                    case 4: {
                        ServerDataStoreEntryImpl entry = (ServerDataStoreEntryImpl)msg.getOldValue();
                        this.removeServerDataListener(entry.getValue());
                        if (ComponentServerDataProvider.this.serverDataEventListener == null) break;
                        ComponentServerDataProvider.this.serverDataEventListener.deleted(entry.getKey());
                        break;
                    }
                    case 6: {
                        Collection entries = (Collection)msg.getOldValue();
                        for (ServerDataStoreEntryImpl entry : entries) {
                            this.removeServerDataListener(entry.getValue());
                            if (ComponentServerDataProvider.this.serverDataEventListener == null) continue;
                            ComponentServerDataProvider.this.serverDataEventListener.deleted(entry.getKey());
                        }
                        break;
                    }
                }
            }
            super.notifyChanged(msg);
        }

        protected void addServerDataListener(String serverName, Notifier notifier) {
            notifier.eAdapters().add(new ServerDataListener(serverName));
        }

        protected void removeServerDataListener(Notifier notifier) {
            HashSet<Adapter> listeners = new HashSet<Adapter>();
            for (Adapter adapter : notifier.eAdapters()) {
                if (!(adapter instanceof ServerDataListener)) continue;
                listeners.add(adapter);
            }
            notifier.eAdapters().removeAll(listeners);
        }
    }
}

