/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.util;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.fusesource.camel.component.sap.model.rfc.AbapException;
import org.fusesource.camel.component.sap.model.rfc.Destination;
import org.fusesource.camel.component.sap.model.rfc.FieldMetaData;
import org.fusesource.camel.component.sap.model.rfc.FunctionTemplate;
import org.fusesource.camel.component.sap.model.rfc.ListFieldMetaData;
import org.fusesource.camel.component.sap.model.rfc.RFC;
import org.fusesource.camel.component.sap.model.rfc.RecordMetaData;
import org.fusesource.camel.component.sap.model.rfc.RepositoryData;
import org.fusesource.camel.component.sap.model.rfc.RfcFactory;
import org.fusesource.camel.component.sap.model.rfc.RfcPackage;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.xml.sax.InputSource;

public class RfcUtil {
    public static final String ROW = "row";
    public static final String GenNS_URI = "http://www.eclipse.org/emf/2002/GenModel";
    public static final String GenNS_DOCUMENTATION_KEY = "documentation";
    public static final String RfcNS_DESCRIPTION_KEY = "description";
    public static final String RfcNS_CLASS_NAME_OF_FIELD_KEY = "classNameOfField";
    public static final String RfcNS_RECORD_TYPE_NAME_KEY = "recordTypeName";
    public static final String RfcNS_TYPE_KEY = "type";
    public static final String RfcNS_TYPE_AS_STRING_KEY = "typeAsString";
    public static final String RfcNS_UNICODE_BYTE_LENGTH_KEY = "unicodeByteLength";
    public static final String RfcNS_UNICODE_BYTE_OFFSET_KEY = "unicodeByteOffset";
    public static final String RfcNS_UNICODE_RECORD_LENGTH_KEY = "unicodeRecordLength";
    public static final String RfcNS_BYTE_LENGTH_KEY = "byteLength";
    public static final String RfcNS_BYTE_OFFSET_KEY = "byteOffset";
    public static final String RfcNS_LENGTH_KEY = "length";
    public static final String RfcNS_DECIMALS_KEY = "decimals";
    public static final String RfcNS_DEFAULT_KEY = "default";
    public static final String RfcNS_RECORD_FIELD_NAME_KEY = "recordFieldName";
    public static final String RfcNS_IS_ABAP_OBJECT_KEY = "isAbapObject";
    public static final String RfcNS_IS_NESTED_TYPE1_STRUCTURE_KEY = "isNestedType1Structure";
    public static final String RfcNS_IS_STRUCTURE_KEY = "isStructure";
    public static final String RfcNS_IS_TABLE_KEY = "isTable";
    public static final String RfcNS_IS_IMPORT_KEY = "isImport";
    public static final String RfcNS_IS_EXPORT_KEY = "isExport";
    public static final String RfcNS_IS_CHANGING_KEY = "isChanging";
    public static final String RfcNS_IS_EXCEPTION_KEY = "isException";
    public static final String RfcNS_IS_OPTIONAL_KEY = "isOptional";
    private static final String STEXT_PARAM = "STEXT";
    private static final String FUNCTIONS_TABLE = "FUNCTIONS";
    private static final String FUNCNAME_PARAM = "FUNCNAME";
    private static final String RFC_FUNCTION_SEARCH_FUNCTION = "RFC_FUNCTION_SEARCH";
    private static final String GROUPNAME_PARAM = "GROUPNAME";

    private RfcUtil() {
    }

    public static Destination getDestination(String destinationName) {
        try {
            JCoDestination jcoDestination = JCoDestinationManager.getDestination((String)destinationName);
            Destination destination = RfcFactory.eINSTANCE.createDestination();
            String repositoryName = jcoDestination.getRepository().getName();
            destination.setName(destinationName);
            destination.setRepositoryName(repositoryName);
            return destination;
        }
        catch (JCoException jCoException) {
            return null;
        }
    }

    public static List<RFC> getRFCs(JCoDestination jcoDestination, String functionNameFilter, String groupNameFilter) {
        ArrayList<RFC> rfcs = new ArrayList<RFC>();
        try {
            JCoFunction jcoFunction = jcoDestination.getRepository().getFunction(RFC_FUNCTION_SEARCH_FUNCTION);
            jcoFunction.getImportParameterList().setValue(FUNCNAME_PARAM, functionNameFilter);
            jcoFunction.getImportParameterList().setValue(GROUPNAME_PARAM, groupNameFilter);
            jcoFunction.execute(jcoDestination);
            JCoTable sapFunctions = jcoFunction.getTableParameterList().getTable(FUNCTIONS_TABLE);
            if (sapFunctions.getNumRows() > 0) {
                sapFunctions.firstRow();
                do {
                    RFC rfc = RfcFactory.eINSTANCE.createRFC();
                    String functionName = sapFunctions.getString(FUNCNAME_PARAM);
                    String groupName = sapFunctions.getString(GROUPNAME_PARAM);
                    rfc.setName(functionName);
                    rfc.setGroup(groupName);
                    String functionDescription = sapFunctions.getString(STEXT_PARAM);
                    rfc.setDescription(functionDescription);
                    rfcs.add(rfc);
                } while (sapFunctions.nextRow());
            }
        }
        catch (JCoException jCoException) {}
        return rfcs;
    }

    public static Structure executeFunction(JCoDestination destination, String functionName, Structure request) throws JCoException {
        JCoFunction jcoFunction = destination.getRepository().getFunction(functionName);
        RfcUtil.fillJCoParameterListsFromRequest(request, jcoFunction);
        jcoFunction.execute(destination);
        Structure response = RfcUtil.getResponse(destination.getRepository(), functionName);
        RfcUtil.extractJCoParameterListsIntoResponse(jcoFunction, response);
        return response;
    }

    public static void executeFunction(JCoDestination destination, String functionName, Structure request, String tid) throws JCoException {
        JCoFunction jcoFunction = destination.getRepository().getFunction(functionName);
        RfcUtil.fillJCoParameterListsFromRequest(request, jcoFunction);
        jcoFunction.execute(destination, tid);
    }

    public static void executeFunction(JCoDestination destination, String functionName, Structure request, String tid, String queueName) throws JCoException {
        JCoFunction jcoFunction = destination.getRepository().getFunction(functionName);
        RfcUtil.fillJCoParameterListsFromRequest(request, jcoFunction);
        jcoFunction.execute(destination, tid, queueName);
    }

    public static void fillJCoParameterListsFromRequest(Structure request, JCoFunction jcoFunction) {
        RfcUtil.fillJCoRecordFromStructure(request, (JCoRecord)jcoFunction.getImportParameterList());
        RfcUtil.fillJCoRecordFromStructure(request, (JCoRecord)jcoFunction.getChangingParameterList());
        RfcUtil.fillJCoRecordFromStructure(request, (JCoRecord)jcoFunction.getTableParameterList());
    }

    public static void fillJCoParameterListsFromResponse(Structure response, JCoFunction jcoFunction) {
        RfcUtil.fillJCoRecordFromStructure(response, (JCoRecord)jcoFunction.getChangingParameterList());
        RfcUtil.fillJCoRecordFromStructure(response, (JCoRecord)jcoFunction.getTableParameterList());
        RfcUtil.fillJCoRecordFromStructure(response, (JCoRecord)jcoFunction.getExportParameterList());
    }

    public static void extractJCoParameterListsIntoRequest(JCoFunction jcoFunction, Structure request) {
        RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoFunction.getImportParameterList(), request);
        RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoFunction.getChangingParameterList(), request);
        RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoFunction.getTableParameterList(), request);
    }

    public static void extractJCoParameterListsIntoResponse(JCoFunction jcoFunction, Structure response) {
        RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoFunction.getChangingParameterList(), response);
        RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoFunction.getTableParameterList(), response);
        RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoFunction.getExportParameterList(), response);
    }

    public static void beginTransaction(JCoDestination jcoDestination) {
        JCoContext.begin((JCoDestination)jcoDestination);
    }

    public static void commitTransaction(JCoDestination jcoDestination) throws JCoException {
        try {
            JCoRequest request = jcoDestination.getRepository().getRequest("BAPI_TRANSACTION_COMMIT");
            request.setValue("WAIT", "X");
            request.execute(jcoDestination);
        }
        finally {
            JCoContext.end((JCoDestination)jcoDestination);
        }
    }

    public static void rollbackTransaction(JCoDestination jcoDestination) throws JCoException {
        try {
            JCoRequest request = jcoDestination.getRepository().getRequest("BAPI_TRANSACTION_ROLLBACK");
            request.execute(jcoDestination);
        }
        finally {
            JCoContext.end((JCoDestination)jcoDestination);
        }
    }

    public static Object getValue(EObject object, String featureName) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        return RfcUtil.getValue(object, feature);
    }

    public static Object getValue(EObject object, EStructuralFeature feature) {
        try {
            Object value = object.eGet(feature);
            if (value == null && feature instanceof EReference) {
                EClass eClass = ((EReference)feature).getEReferenceType();
                value = eClass.getEPackage().getEFactoryInstance().create(eClass);
                RfcUtil.setValue(object, feature, value);
            }
            return value;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean setValue(EObject object, String featureName, Object value) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return false;
        }
        return RfcUtil.setValue(object, feature, value);
    }

    public static boolean setValue(EObject object, EStructuralFeature feature, Object value) {
        try {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object);
            if (editingDomain == null) {
                object.eSet(feature, value);
            } else {
                Command setCommand = SetCommand.create(editingDomain, object, feature, value);
                editingDomain.getCommandStack().execute(setCommand);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Structure addTableRow(Table<? extends Structure> table) {
        EStructuralFeature feature = table.eClass().getEStructuralFeature(ROW);
        if (feature == null || !(feature instanceof EReference)) {
            return null;
        }
        EClass rowType = ((EReference)feature).getEReferenceType();
        EList records = (EList)RfcUtil.getValue(table, feature);
        Structure newRow = (Structure)rowType.getEPackage().getEFactoryInstance().create(rowType);
        records.add(newRow);
        return newRow;
    }

    public static Structure addTableRow(Table<? extends Structure> table, int index) {
        EStructuralFeature feature = table.eClass().getEStructuralFeature(ROW);
        if (feature == null || !(feature instanceof EReference)) {
            return null;
        }
        EClass rowType = ((EReference)feature).getEReferenceType();
        EList records = (EList)RfcUtil.getValue(table, feature);
        Structure newRow = (Structure)rowType.getEPackage().getEFactoryInstance().create(rowType);
        records.add(index, newRow);
        return newRow;
    }

    public static void extractJCoRecordIntoStructure(JCoRecord jrecord, Structure eObject) {
        if (jrecord == null || eObject == null) {
            return;
        }
        EClass eClass = eObject.eClass();
        JCoFieldIterator iterator = jrecord.getFieldIterator();
        while (iterator.hasNextField()) {
            JCoField field = iterator.nextField();
            EStructuralFeature feature = eClass.getEStructuralFeature(field.getName());
            Object value = RfcUtil.getValue((EObject)eObject, feature);
            if (field.isStructure()) {
                if (value == null || !(value instanceof EObject)) continue;
                RfcUtil.extractJCoRecordIntoStructure((JCoRecord)field.getStructure(), (Structure)value);
                continue;
            }
            if (field.isTable()) {
                if (value == null || !(value instanceof EObject)) continue;
                RfcUtil.extractJCoTableIntoTable(field.getTable(), (Table)value);
                continue;
            }
            RfcUtil.setValue((EObject)eObject, feature, field.getValue());
        }
    }

    public static void fillJCoRecordFromStructure(Structure eObject, JCoRecord jcoRecord) {
        if (jcoRecord == null || eObject == null) {
            return;
        }
        EClass eClass = eObject.eClass();
        JCoFieldIterator iterator = jcoRecord.getFieldIterator();
        while (iterator.hasNextField()) {
            JCoField field = iterator.nextField();
            EStructuralFeature feature = eClass.getEStructuralFeature(field.getName());
            Object value = RfcUtil.getValue((EObject)eObject, feature);
            if (field.isStructure()) {
                if (value == null || !(value instanceof Structure)) continue;
                RfcUtil.fillJCoRecordFromStructure((Structure)value, (JCoRecord)field.getStructure());
                continue;
            }
            if (field.isTable()) {
                if (value == null || !(value instanceof Table)) continue;
                RfcUtil.fillJCoTableFromTable((Table)value, field.getTable());
                continue;
            }
            field.setValue(value);
        }
    }

    public static void extractJCoTableIntoTable(JCoTable jcoTable, Table<? extends Structure> table) {
        if (table == null || jcoTable == null) {
            return;
        }
        EStructuralFeature feature = table.eClass().getEStructuralFeature(ROW);
        if (feature == null || !(feature instanceof EReference)) {
            return;
        }
        EClass rowType = ((EReference)feature).getEReferenceType();
        EList records = (EList)RfcUtil.getValue(table, feature);
        jcoTable.firstRow();
        int i = 0;
        while (i < jcoTable.getNumRows()) {
            Structure newRow = (Structure)rowType.getEPackage().getEFactoryInstance().create(rowType);
            records.add(newRow);
            RfcUtil.extractJCoRecordIntoStructure((JCoRecord)jcoTable, newRow);
            ++i;
            jcoTable.nextRow();
        }
    }

    public static void fillJCoTableFromTable(Table<? extends Structure> table, JCoTable jcoTable) {
        if (table == null || jcoTable == null) {
            return;
        }
        EStructuralFeature feature = table.eClass().getEStructuralFeature(ROW);
        EList records = (EList)RfcUtil.getValue(table, feature);
        for (Structure row : records) {
            jcoTable.appendRow();
            RfcUtil.fillJCoRecordFromStructure(row, (JCoRecord)jcoTable);
        }
    }

    public static Structure getRequest(JCoRepository repository, String functionModuleName) {
        return (Structure)RfcUtil.getInstance(repository, functionModuleName, "Request");
    }

    public static Structure getResponse(JCoRepository repository, String functionModuleName) {
        return (Structure)RfcUtil.getInstance(repository, functionModuleName, "Response");
    }

    public static EObject getInstance(JCoRepository repository, String functionModuleName, String eClassName) {
        String nsURI = "http://sap.fusesource.org/rfc/" + repository.getName() + "/" + functionModuleName;
        EPackage ePackage = RfcUtil.getEPackage(repository, nsURI);
        EClassifier classifier = ePackage.getEClassifier(eClassName);
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)classifier;
        EObject eObject = ePackage.getEFactoryInstance().create(eClass);
        return eObject;
    }

    public static EPackage getEPackage(JCoRepository repository, String nsURI) {
        EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get(nsURI);
        if (ePackage != null) {
            return ePackage;
        }
        if (nsURI.startsWith("http://sap.fusesource.org/rfc/" + repository.getName())) {
            JCoFunctionTemplate functionTemplate;
            int prefixLength = "http://sap.fusesource.org/rfc".length() + repository.getName().length() + 2;
            String functionModuleName = nsURI.substring(prefixLength);
            try {
                functionTemplate = repository.getFunctionTemplate(functionModuleName);
            }
            catch (JCoException jCoException) {
                return null;
            }
            JCoListMetaData importParameterListMetaData = functionTemplate.getImportParameterList();
            JCoListMetaData changingParameterListMetaData = functionTemplate.getChangingParameterList();
            JCoListMetaData tableParameterListMetaData = functionTemplate.getTableParameterList();
            JCoListMetaData exportParameterListMetaData = functionTemplate.getExportParameterList();
            EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
            ePackage = ecoreFactory.createEPackage();
            ePackage.setName(functionModuleName);
            ePackage.setNsPrefix(functionModuleName);
            ePackage.setNsURI(nsURI);
            EClass requestClass = ecoreFactory.createEClass();
            ePackage.getEClassifiers().add(requestClass);
            requestClass.setName("Request");
            requestClass.getESuperTypes().add(RfcPackage.eINSTANCE.getStructure());
            RfcUtil.addListMetaData(requestClass, importParameterListMetaData);
            RfcUtil.addListMetaData(requestClass, changingParameterListMetaData);
            RfcUtil.addListMetaData(requestClass, tableParameterListMetaData);
            RfcUtil.addAnnotation(requestClass, GenNS_URI, GenNS_DOCUMENTATION_KEY, "Request for " + functionModuleName);
            EClass responseClass = ecoreFactory.createEClass();
            ePackage.getEClassifiers().add(responseClass);
            responseClass.setName("Response");
            responseClass.getESuperTypes().add(RfcPackage.eINSTANCE.getStructure());
            RfcUtil.addListMetaData(responseClass, exportParameterListMetaData);
            RfcUtil.addListMetaData(responseClass, changingParameterListMetaData);
            RfcUtil.addListMetaData(responseClass, tableParameterListMetaData);
            RfcUtil.addAnnotation(responseClass, GenNS_URI, GenNS_DOCUMENTATION_KEY, "Response for " + functionModuleName);
            EPackage.Registry.INSTANCE.put(nsURI, ePackage);
        }
        return ePackage;
    }

    public static void addAnnotation(EModelElement modelElement, String source, String key, String value) {
        EAnnotation annotation = modelElement.getEAnnotation(source);
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(source);
            annotation.setEModelElement(modelElement);
        }
        annotation.getDetails().put(key, value);
    }

    public static void addListMetaData(EClass eClass, JCoListMetaData jcoListMetaData) {
        if (jcoListMetaData == null) {
            return;
        }
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EPackage ePackage = eClass.getEPackage();
        int i = 0;
        while (i < jcoListMetaData.getFieldCount()) {
            EStructuralFeature structuralFeature;
            EReference reference;
            JCoRecordMetaData jcoRecordMetaData;
            if (jcoListMetaData.isStructure(i)) {
                jcoRecordMetaData = jcoListMetaData.getRecordMetaData(i);
                EClass structureClass = RfcUtil.getStructureClass(ePackage, jcoRecordMetaData);
                reference = ecoreFactory.createEReference();
                reference.setEType(structureClass);
                reference.setContainment(true);
                structuralFeature = reference;
                RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_CLASS_NAME_OF_FIELD_KEY, EObject.class.getName());
            } else if (jcoListMetaData.isTable(i)) {
                jcoRecordMetaData = jcoListMetaData.getRecordMetaData(i);
                EClass tableClass = RfcUtil.getTableClass(ePackage, jcoRecordMetaData);
                reference = ecoreFactory.createEReference();
                reference.setEType(tableClass);
                reference.setContainment(true);
                structuralFeature = reference;
                RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_CLASS_NAME_OF_FIELD_KEY, EObject.class.getName());
            } else {
                EAttribute attribute = ecoreFactory.createEAttribute();
                attribute.setEType(RfcUtil.getEDataType(jcoListMetaData.getType(i)));
                structuralFeature = attribute;
                RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_CLASS_NAME_OF_FIELD_KEY, jcoListMetaData.getClassNameOfField(i));
            }
            structuralFeature.setName(jcoListMetaData.getName(i));
            if (!jcoListMetaData.isOptional(i)) {
                structuralFeature.setLowerBound(1);
            }
            if (jcoListMetaData.getDefault(i) != null) {
                structuralFeature.setDefaultValueLiteral(jcoListMetaData.getDefault(i));
            }
            RfcUtil.addAnnotation(structuralFeature, GenNS_URI, GenNS_DOCUMENTATION_KEY, jcoListMetaData.getDescription(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_DESCRIPTION_KEY, jcoListMetaData.getDescription(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_TYPE_KEY, Integer.toString(jcoListMetaData.getType(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_TYPE_AS_STRING_KEY, jcoListMetaData.getTypeAsString(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_RECORD_TYPE_NAME_KEY, jcoListMetaData.getRecordTypeName(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_LENGTH_KEY, Integer.toString(jcoListMetaData.getLength(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_BYTE_LENGTH_KEY, Integer.toString(jcoListMetaData.getByteLength(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_UNICODE_BYTE_LENGTH_KEY, Integer.toString(jcoListMetaData.getUnicodeByteLength(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_DECIMALS_KEY, Integer.toString(jcoListMetaData.getDecimals(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_DEFAULT_KEY, jcoListMetaData.getDefault(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_RECORD_FIELD_NAME_KEY, jcoListMetaData.getRecordFieldName(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_ABAP_OBJECT_KEY, Boolean.toString(jcoListMetaData.isAbapObject(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_NESTED_TYPE1_STRUCTURE_KEY, Boolean.toString(jcoListMetaData.isNestedType1Structure(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_STRUCTURE_KEY, Boolean.toString(jcoListMetaData.isStructure(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_TABLE_KEY, Boolean.toString(jcoListMetaData.isTable(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_IMPORT_KEY, Boolean.toString(jcoListMetaData.isImport(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_EXCEPTION_KEY, Boolean.toString(jcoListMetaData.isException(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_EXPORT_KEY, Boolean.toString(jcoListMetaData.isExport(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_CHANGING_KEY, Boolean.toString(jcoListMetaData.isChanging(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_OPTIONAL_KEY, Boolean.toString(jcoListMetaData.isOptional(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_RECORD_FIELD_NAME_KEY, jcoListMetaData.getRecordFieldName(i));
            eClass.getEStructuralFeatures().add(structuralFeature);
            ++i;
        }
    }

    public static EClass getStructureClass(EPackage ePackage, JCoRecordMetaData jcoRecordMetaData) {
        EClassifier structureClass = ePackage.getEClassifier(jcoRecordMetaData.getName());
        if (!(structureClass instanceof EClass)) {
            structureClass = EcoreFactory.eINSTANCE.createEClass();
            ePackage.getEClassifiers().add(structureClass);
            structureClass.setName(jcoRecordMetaData.getName());
            RfcUtil.addRecordMetaData((EClass)structureClass, jcoRecordMetaData);
            ((EClass)structureClass).getESuperTypes().add(RfcPackage.eINSTANCE.getStructure());
        }
        return (EClass)structureClass;
    }

    public static EClass getTableClass(EPackage ePackage, JCoRecordMetaData jcoRecordMetaData) {
        EClassifier tableClass = ePackage.getEClassifier(String.valueOf(jcoRecordMetaData.getName()) + "_TABLE");
        if (!(tableClass instanceof EClass)) {
            EGenericType tableGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
            EClass tableSuperClass = RfcPackage.eINSTANCE.getTable();
            tableGenericSuperType.setEClassifier(tableSuperClass);
            EGenericType rowGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            EClass structureType = RfcUtil.getStructureClass(ePackage, jcoRecordMetaData);
            rowGenericType.setEClassifier(structureType);
            tableGenericSuperType.getETypeArguments().add(rowGenericType);
            tableClass = EcoreFactory.eINSTANCE.createEClass();
            ePackage.getEClassifiers().add(tableClass);
            tableClass.setName(String.valueOf(jcoRecordMetaData.getName()) + "_TABLE");
            ((EClass)tableClass).getEGenericSuperTypes().add(tableGenericSuperType);
            EReference rowReference = EcoreFactory.eINSTANCE.createEReference();
            rowReference.setEType(structureType);
            rowReference.setName(ROW);
            rowReference.setContainment(true);
            rowReference.setLowerBound(0);
            rowReference.setUpperBound(-1);
            ((EClass)tableClass).getEStructuralFeatures().add(rowReference);
        }
        return (EClass)tableClass;
    }

    public static void addRecordMetaData(EClass eClass, JCoRecordMetaData jcoRecordMetaData) {
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EPackage ePackage = eClass.getEPackage();
        int i = 0;
        while (i < jcoRecordMetaData.getFieldCount()) {
            EStructuralFeature structuralFeature;
            EReference reference;
            JCoRecordMetaData jcoSubRecordMetaData;
            if (jcoRecordMetaData.isStructure(i)) {
                jcoSubRecordMetaData = jcoRecordMetaData.getRecordMetaData(i);
                EClass structureClass = RfcUtil.getStructureClass(ePackage, jcoSubRecordMetaData);
                reference = ecoreFactory.createEReference();
                structuralFeature = reference;
                reference.setEType(structureClass);
                reference.setContainment(true);
                RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_CLASS_NAME_OF_FIELD_KEY, EObject.class.getName());
            } else if (jcoRecordMetaData.isTable(i)) {
                jcoSubRecordMetaData = jcoRecordMetaData.getRecordMetaData(i);
                EClass tableClass = RfcUtil.getTableClass(ePackage, jcoSubRecordMetaData);
                reference = ecoreFactory.createEReference();
                structuralFeature = reference;
                reference.setEType(tableClass);
                reference.setContainment(true);
                RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_CLASS_NAME_OF_FIELD_KEY, EObject.class.getName());
            } else {
                EAttribute attribute = ecoreFactory.createEAttribute();
                structuralFeature = attribute;
                attribute.setEType(RfcUtil.getEDataType(jcoRecordMetaData.getType(i)));
                RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_CLASS_NAME_OF_FIELD_KEY, jcoRecordMetaData.getClassNameOfField(i));
            }
            structuralFeature.setName(jcoRecordMetaData.getName(i));
            RfcUtil.addAnnotation(structuralFeature, GenNS_URI, GenNS_DOCUMENTATION_KEY, jcoRecordMetaData.getDescription(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_DESCRIPTION_KEY, jcoRecordMetaData.getDescription(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_TYPE_KEY, Integer.toString(jcoRecordMetaData.getType(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_TYPE_AS_STRING_KEY, jcoRecordMetaData.getTypeAsString(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_RECORD_TYPE_NAME_KEY, jcoRecordMetaData.getRecordTypeName(i));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_LENGTH_KEY, Integer.toString(jcoRecordMetaData.getLength(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_BYTE_LENGTH_KEY, Integer.toString(jcoRecordMetaData.getByteLength(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_BYTE_OFFSET_KEY, Integer.toString(jcoRecordMetaData.getByteOffset(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_UNICODE_BYTE_LENGTH_KEY, Integer.toString(jcoRecordMetaData.getUnicodeByteLength(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_UNICODE_BYTE_OFFSET_KEY, Integer.toString(jcoRecordMetaData.getUnicodeByteOffset(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_DECIMALS_KEY, Integer.toString(jcoRecordMetaData.getDecimals(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_ABAP_OBJECT_KEY, Boolean.toString(jcoRecordMetaData.isAbapObject(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_NESTED_TYPE1_STRUCTURE_KEY, Boolean.toString(jcoRecordMetaData.isNestedType1Structure(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_STRUCTURE_KEY, Boolean.toString(jcoRecordMetaData.isStructure(i)));
            RfcUtil.addAnnotation(structuralFeature, "http://sap.fusesource.org/rfc", RfcNS_IS_TABLE_KEY, Boolean.toString(jcoRecordMetaData.isTable(i)));
            eClass.getEStructuralFeatures().add(structuralFeature);
            ++i;
        }
    }

    public static EClassifier getEDataType(int jcoDataType) {
        switch (jcoDataType) {
            case 8: 
            case 9: 
            case 10: {
                return EcorePackage.Literals.EINT;
            }
            case 0: {
                return EcorePackage.Literals.ESTRING;
            }
            case 6: {
                return EcorePackage.Literals.ESTRING;
            }
            case 2: {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
            case 1: {
                return EcorePackage.Literals.EDATE;
            }
            case 3: {
                return EcorePackage.Literals.EDATE;
            }
            case 7: {
                return EcorePackage.Literals.EDOUBLE;
            }
            case 4: {
                return EcorePackage.Literals.EBYTE_ARRAY;
            }
            case 29: {
                return EcorePackage.Literals.ESTRING;
            }
            case 30: {
                return EcorePackage.Literals.EBYTE_ARRAY;
            }
            case 23: {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
            case 24: {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
            case 17: {
                return EcorePackage.Literals.EOBJECT;
            }
            case 99: {
                return EcorePackage.Literals.EOBJECT;
            }
        }
        return EcorePackage.Literals.EBYTE_ARRAY;
    }

    public static void print(EObject eObject) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        resource.getContents().add(eObject);
        resource.save(System.out, null);
    }

    public static OutputStream toOutputStream(EObject eObject) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        eObject = EcoreUtil.copy(eObject);
        resource.getContents().add(eObject);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        resource.save(out, null);
        return out;
    }

    public static InputStream toInputStream(EObject eObject) throws IOException {
        String string = RfcUtil.marshal(eObject);
        ByteArrayInputStream in = new ByteArrayInputStream(string.getBytes());
        return in;
    }

    public static EObject fromInputStream(InputStream in) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        resource.load(in, null);
        return (EObject)resource.getContents().get(0);
    }

    public static String marshal(EObject eObject) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        eObject = EcoreUtil.copy(eObject);
        resource.getContents().add(eObject);
        StringWriter out = new StringWriter();
        resource.save(out, null);
        return out.toString();
    }

    public static EObject unmarshal(String string) throws IOException {
        XMLResourceImpl resource = new XMLResourceImpl();
        StringReader in = new StringReader(string);
        resource.load(new InputSource(in), null);
        return (EObject)resource.getContents().get(0);
    }

    public static JCoCustomRepository createRepository(String repositoryName, RepositoryData repositoryData) {
        JCoCustomRepository customRepository = JCo.createCustomRepository((String)repositoryName);
        for (String functionTemplateName : repositoryData.getEntries().keySet()) {
            FunctionTemplate functionTemplate = repositoryData.getEntries().get(functionTemplateName);
            JCoFunctionTemplate jcoFunctionTemplate = RfcUtil.createJCoFunctionTemplate(functionTemplateName, functionTemplate);
            customRepository.addFunctionTemplateToCache(jcoFunctionTemplate);
        }
        return customRepository;
    }

    public static JCoFunctionTemplate createJCoFunctionTemplate(String name, FunctionTemplate functionTemplate) {
        JCoListMetaData importsMetaData = RfcUtil.createJCoListMetaData("IMPORTS", functionTemplate.getImportParameterList());
        JCoListMetaData exportsMetaData = RfcUtil.createJCoListMetaData("EXPORTS", functionTemplate.getExportParameterList());
        JCoListMetaData changingMetaData = RfcUtil.createJCoListMetaData("CHANGING", functionTemplate.getChangingParameterList());
        JCoListMetaData tablesMetaData = RfcUtil.createJCoListMetaData("TABLES", functionTemplate.getTables());
        com.sap.conn.jco.AbapException[] jcoAbapExceptions = RfcUtil.createAbapExceptions(functionTemplate.getExceptionList());
        JCoFunctionTemplate jcoFunctionTemplate = JCo.createFunctionTemplate((String)name, (JCoListMetaData)importsMetaData, (JCoListMetaData)exportsMetaData, (JCoListMetaData)changingMetaData, (JCoListMetaData)tablesMetaData, (com.sap.conn.jco.AbapException[])jcoAbapExceptions);
        return jcoFunctionTemplate;
    }

    public static JCoListMetaData createJCoListMetaData(String name, List<ListFieldMetaData> listDescriptors) {
        JCoListMetaData jcoListMetaData = JCo.createListMetaData((String)name);
        for (ListFieldMetaData listFieldDescriptor : listDescriptors) {
            int flags = 0;
            flags |= listFieldDescriptor.isImport() ? 2 : 0;
            flags |= listFieldDescriptor.isExport() ? 4 : 0;
            flags |= listFieldDescriptor.isChanging() ? 8 : 0;
            flags |= listFieldDescriptor.isOptional() ? 1 : 0;
            switch (listFieldDescriptor.getType().getValue()) {
                case 17: 
                case 99: {
                    JCoRecordMetaData jcoRecordMetaData = RfcUtil.createJCoRecordMetaData(listFieldDescriptor.getRecordMetaData());
                    jcoListMetaData.add(listFieldDescriptor.getName(), listFieldDescriptor.getType().getValue(), jcoRecordMetaData, flags);
                    break;
                }
                default: {
                    jcoListMetaData.add(listFieldDescriptor.getName(), listFieldDescriptor.getType().getValue(), listFieldDescriptor.getByteLength(), listFieldDescriptor.getUnicodeByteLength(), listFieldDescriptor.getDecimals(), listFieldDescriptor.getDescription(), null, flags, null, null);
                }
            }
        }
        jcoListMetaData.lock();
        return jcoListMetaData;
    }

    public static JCoRecordMetaData createJCoRecordMetaData(RecordMetaData recordMetaData) {
        JCoRecordMetaData jcoRecordMetaData = JCo.createRecordMetaData((String)recordMetaData.getName());
        for (FieldMetaData fieldDescriptor : recordMetaData.getRecordFieldMetaData()) {
            switch (fieldDescriptor.getType().getValue()) {
                case 17: 
                case 99: {
                    JCoRecordMetaData recordMetaData2 = RfcUtil.createJCoRecordMetaData(fieldDescriptor.getRecordMetaData());
                    jcoRecordMetaData.add(fieldDescriptor.getName(), fieldDescriptor.getType().getValue(), fieldDescriptor.getByteOffset(), fieldDescriptor.getUnicodeByteOffset(), recordMetaData2);
                    break;
                }
                default: {
                    jcoRecordMetaData.add(fieldDescriptor.getName(), fieldDescriptor.getType().getValue(), fieldDescriptor.getByteLength(), fieldDescriptor.getByteOffset(), fieldDescriptor.getUnicodeByteLength(), fieldDescriptor.getUnicodeByteOffset(), fieldDescriptor.getDecimals(), fieldDescriptor.getDescription(), null, null);
                }
            }
        }
        jcoRecordMetaData.lock();
        return jcoRecordMetaData;
    }

    public static com.sap.conn.jco.AbapException[] createAbapExceptions(List<AbapException> abapExceptions) {
        com.sap.conn.jco.AbapException[] jcoAbapExceptions = new com.sap.conn.jco.AbapException[abapExceptions.size()];
        int i = 0;
        while (i < abapExceptions.size()) {
            AbapException abapException = abapExceptions.get(i);
            jcoAbapExceptions[i] = new com.sap.conn.jco.AbapException(abapException.getKey(), abapException.getMessage());
            ++i;
        }
        return jcoAbapExceptions;
    }
}

