/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.bridge.GatewayConnector;
import org.fusesource.fabric.bridge.model.BrokerConfig;
import org.fusesource.fabric.bridge.model.RemoteBridge;
import org.fusesource.fabric.bridge.zk.internal.ZkConfigHelper;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="zkgateway-connector")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ZkGatewayConnector
extends GatewayConnector
implements Runnable,
LifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZkGatewayConnector.class);
    @XmlElement(name="exported-broker")
    private BrokerConfig exportedBrokerConfig;
    @XmlAttribute
    private String versionName;
    @XmlAttribute(required=true)
    private String profileName;
    @XmlAttribute(required=true)
    private String zooKeeperRef;
    private IZKClient zooKeeper;
    @XmlAttribute(required=true)
    private String fabricServiceRef;
    private FabricService fabricService;
    @XmlAttribute
    private long updateInterval = 10L;
    private Profile gatewayProfile;
    private ScheduledExecutorService bridgeLookupExecutor;
    private Map<String, RemoteBridge> containerBridgeMap = new HashMap<String, RemoteBridge>();
    private volatile boolean connected;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.exportedBrokerConfig == null) {
            LOG.warn("The property exportedBrokerConfig is not set, exporting property localBrokerConfig");
        } else if (this.exportedBrokerConfig.getBrokerUrl() == null && this.exportedBrokerConfig.getConnectionFactory() == null || this.exportedBrokerConfig.getBrokerUrl() != null && this.exportedBrokerConfig.getConnectionFactory() != null) {
            throw new IllegalArgumentException("Either a exported broker url or connection factory must be provided");
        }
        if (this.profileName == null) {
            throw new IllegalArgumentException("Property profileName must be set");
        }
        if (this.zooKeeper == null) {
            throw new IllegalArgumentException("Property zooKeeper must be set");
        }
        if (this.fabricService == null) {
            throw new IllegalArgumentException("Property fabricService must be set");
        }
        this.zooKeeper.registerListener((LifecycleListener)this);
        this.connected = true;
        RemoteBridge remoteBridge = new RemoteBridge();
        remoteBridge.setRemoteBrokerConfig(this.exportedBrokerConfig != null ? this.exportedBrokerConfig : super.getLocalBrokerConfig());
        remoteBridge.setInboundDestinations(super.getInboundDestinations());
        remoteBridge.setOutboundDestinations(super.getOutboundDestinations());
        if (this.versionName == null) {
            this.versionName = this.fabricService.getDefaultVersion().getName();
        }
        LOG.info("Looking for profile " + this.profileName + " under version " + this.versionName);
        Version version = this.fabricService.getVersion(this.versionName);
        this.gatewayProfile = version.getProfile(this.profileName);
        if (this.gatewayProfile == null) {
            LOG.info("Creating profile " + this.profileName + " under version " + this.versionName);
            this.gatewayProfile = version.createProfile(this.profileName);
        }
        LOG.info("Registering gateway under profile " + this.gatewayProfile);
        ZkConfigHelper.registerGateway(this.gatewayProfile, remoteBridge);
    }

    protected void doStart() {
        super.doStart();
        this.bridgeLookupExecutor = Executors.newSingleThreadScheduledExecutor();
        this.bridgeLookupExecutor.scheduleWithFixedDelay(this, 0L, this.updateInterval, TimeUnit.SECONDS);
        LOG.info("Started");
    }

    protected void doStop() {
        this.bridgeLookupExecutor.shutdown();
        if (this.connected) {
            try {
                this.zooKeeper.removeListener((LifecycleListener)this);
                this.connected = false;
            }
            catch (Exception e) {
                LOG.error("Error removing Gateway Connector as ZooKeeper listener: " + e.getMessage(), (Throwable)e);
            }
        }
        super.doStop();
        LOG.info("Stopped");
    }

    @Override
    public void run() {
        Container[] containers;
        if (!this.connected) {
            LOG.warn("Gateway is not connected to Fabric Zookeeper service, will retry after " + this.updateInterval + " seconds");
            return;
        }
        try {
            containers = this.gatewayProfile.getAssociatedContainers();
        }
        catch (FabricException e) {
            String msg = "Error getting Containers from Fabric: " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        if (containers.length == 0 && LOG.isDebugEnabled()) {
            LOG.debug("No BridgeConnector containers found");
        }
        for (Container container : containers) {
            String containerId = container.getId();
            try {
                RemoteBridge remoteBridge = ZkConfigHelper.getBridgeConfig(this.zooKeeper, container, this.applicationContext);
                RemoteBridge oldRemoteBridge = this.containerBridgeMap.get(containerId);
                if (remoteBridge != null) {
                    if (oldRemoteBridge != null) {
                        if (oldRemoteBridge.equals((Object)remoteBridge)) continue;
                        LOG.info("Refreshing outbound connector for " + containerId);
                        this.containerBridgeMap.remove(containerId);
                        this.removeRemoteBridge(oldRemoteBridge);
                        this.addRemoteBridge(remoteBridge);
                        this.containerBridgeMap.put(containerId, remoteBridge);
                        continue;
                    }
                    try {
                        LOG.info("Found Bridge Configuration for " + containerId);
                        this.addRemoteBridge(remoteBridge);
                        this.containerBridgeMap.put(containerId, remoteBridge);
                        LOG.info("Added outbound connector for " + containerId);
                    }
                    catch (Exception ex) {
                        LOG.error("Error adding outbound conncetor for [" + containerId + "] : " + ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                if (oldRemoteBridge != null) {
                    LOG.info("Removing outbound connector for " + containerId);
                    this.containerBridgeMap.remove(containerId);
                    this.removeRemoteBridge(oldRemoteBridge);
                    continue;
                }
                LOG.warn("Container " + containerId + " uses Profile [" + this.gatewayProfile.getId() + "] but has not yet registered its Bridge Configuration");
            }
            catch (Exception ex) {
                LOG.error("Error getting Bridge Configuration for container [" + containerId + "]: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onConnected() {
        LOG.info("Gateway connected to Fabric Zookeeper service");
        this.connected = true;
    }

    public void onDisconnected() {
        LOG.warn("Gateway disconnected from Fabric Zookeeper service");
        this.connected = false;
    }

    public void setExportedBrokerConfig(BrokerConfig exportedBrokerConfig) {
        this.exportedBrokerConfig = exportedBrokerConfig;
    }

    public BrokerConfig getExportedBrokerConfig() {
        return this.exportedBrokerConfig;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getZooKeeperRef() {
        return this.zooKeeperRef;
    }

    public void setZooKeeperRef(String zooKeeperRef) {
        this.zooKeeperRef = zooKeeperRef;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public String getFabricServiceRef() {
        return this.fabricServiceRef;
    }

    public void setFabricServiceRef(String fabricServiceRef) {
        this.fabricServiceRef = fabricServiceRef;
    }

    public final FabricService getFabricService() {
        return this.fabricService;
    }

    public final void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }
}

