/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.bridge.model.BrokerConfig;
import org.fusesource.fabric.bridge.model.RemoteBridge;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.StringUtils;

public abstract class ZkConfigHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ZkConfigHelper.class);
    private static final String GATEWAY_CONNECTOR_PID = "org.fusesource.fabric.bridge.gatewayRemoteBridge.xml";
    private static final String BRIDGE_CONNECTOR_PID = "org.fusesource.fabric.bridge.bridgeRemoteBridge.xml";
    private static JAXBContext jaxbContext;

    public static RemoteBridge getBridgeConfig(IZKClient client, Container container, ApplicationContext context) {
        String bridgeConfigPath = ZkConfigHelper.getBridgeConfigPath(container);
        RemoteBridge remoteBridge = ZkConfigHelper.getData(client, bridgeConfigPath, RemoteBridge.class);
        if (remoteBridge != null) {
            ZkConfigHelper.resolveBeanReferences(remoteBridge.getRemoteBrokerConfig(), context);
        }
        return remoteBridge;
    }

    public static void registerBridge(IZKClient client, Container container, RemoteBridge remoteBridge) {
        byte[] data = ZkConfigHelper.getZkData(remoteBridge);
        String bridgeConfigPath = ZkConfigHelper.getBridgeConfigPath(container);
        try {
            ZooKeeperUtils.set((IZKClient)client, (String)bridgeConfigPath, (byte[])data);
        }
        catch (InterruptedException e) {
            String msg = "Error registering bridge config at " + bridgeConfigPath + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        catch (KeeperException e) {
            String msg = "Error registering bridge config at " + bridgeConfigPath + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static void removeBridge(IZKClient client, Container container) {
        String bridgeConfigPath = ZkConfigHelper.getBridgeConfigPath(container);
        try {
            client.deleteWithChildren(bridgeConfigPath);
        }
        catch (InterruptedException e) {
            String msg = "Error removing bridge config at " + bridgeConfigPath + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        catch (KeeperException e) {
            String msg = "Error removing bridge config at " + bridgeConfigPath + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static String getBridgeConfigPath(Container container) {
        return ZkPath.CONTAINER.getPath(new String[]{container.getId()}) + "/" + BRIDGE_CONNECTOR_PID;
    }

    public static void registerGateway(Profile gatewayProfile, RemoteBridge remoteBridge) {
        Map fileConfigurations = gatewayProfile.getFileConfigurations();
        fileConfigurations.put(GATEWAY_CONNECTOR_PID, ZkConfigHelper.getZkData(remoteBridge));
        gatewayProfile.setFileConfigurations(fileConfigurations);
    }

    public static RemoteBridge getGatewayConfig(Profile gatewayProfile, ApplicationContext context) {
        byte[] data = (byte[])gatewayProfile.getFileConfigurations().get(GATEWAY_CONNECTOR_PID);
        RemoteBridge remoteBridge = null;
        if (data != null) {
            remoteBridge = ZkConfigHelper.getJaxElementFromData(data, RemoteBridge.class);
            ZkConfigHelper.resolveBeanReferences(remoteBridge.getRemoteBrokerConfig(), context);
        }
        return remoteBridge;
    }

    private static void resolveBeanReferences(BrokerConfig remoteBrokerConfig, ApplicationContext context) {
        String destinationResolverRef = remoteBrokerConfig.getDestinationResolverRef();
        if (StringUtils.hasText((String)destinationResolverRef)) {
            remoteBrokerConfig.setDestinationResolver((DestinationResolver)context.getBean(destinationResolverRef, DestinationResolver.class));
        }
    }

    private static byte[] getZkData(Object jaxbElement) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            jaxbContext.createMarshaller().marshal(jaxbElement, (OutputStream)stream);
        }
        catch (JAXBException e) {
            String msg = "Error marshaling [" + jaxbElement.toString() + "] : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        return stream.toByteArray();
    }

    private static <T> T getData(IZKClient client, String path, Class<T> returnType) {
        try {
            if (client.exists(path) == null) {
                return null;
            }
            byte[] data = client.getData(path);
            return ZkConfigHelper.getJaxElementFromData(data, returnType);
        }
        catch (InterruptedException e) {
            String msg = "Error getting " + returnType.getName() + " from " + path + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        catch (KeeperException e) {
            String msg = "Error getting " + returnType.getName() + " from " + path + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static <T> T getJaxElementFromData(byte[] data, Class<T> returnType) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        try {
            Object retVal = jaxbContext.createUnmarshaller().unmarshal((InputStream)stream);
            if (returnType.isInstance(retVal)) {
                return returnType.cast(retVal);
            }
            String msg = "Expected object of type " + returnType.getName() + ", instead found " + retVal.getClass();
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        catch (JAXBException e) {
            String msg = "Error getting " + returnType.getName() + " from fabric data : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RemoteBridge.class});
        }
        catch (JAXBException e) {
            LOG.error("Error creating JAXBContext " + e.getMessage(), (Throwable)e);
        }
    }
}

