/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.fabric.bridge.zk.ZkGatewayConnector;
import org.fusesource.fabric.bridge.zk.internal.AbstractZkManagedServiceFactory;
import org.osgi.service.cm.ConfigurationException;
import org.springframework.util.StringUtils;

public class ZkManagedGatewayServiceFactory
extends AbstractZkManagedServiceFactory {
    private Map<String, ZkGatewayConnector> gatewayConnectorMap = new ConcurrentHashMap<String, ZkGatewayConnector>();

    @Override
    public void doDestroy() throws Exception {
        for (String pid : this.gatewayConnectorMap.keySet()) {
            this.deleted(pid);
        }
    }

    public String getName() {
        return "Fabric Gateway Server";
    }

    public void updated(String pid, Dictionary incoming) throws ConfigurationException {
        if (this.gatewayConnectorMap.containsKey(pid)) {
            this.LOG.info("Refreshing Gateway " + pid);
            this.deleted(pid);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        Enumeration keys = incoming.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = incoming.get(key);
            if (value == null) continue;
            ((Dictionary)properties).put(key, value.toString());
        }
        this.gatewayConnectorMap.put(pid, this.createGatewayConnector(pid, properties));
        this.LOG.info("Started Gateway " + pid);
    }

    @Override
    public void doDeleted(String pid) {
        ZkGatewayConnector gatewayConnector = this.gatewayConnectorMap.remove(pid);
        if (gatewayConnector != null) {
            try {
                gatewayConnector.destroy();
                this.LOG.info("Destroyed Gateway " + pid);
            }
            catch (Exception e) {
                this.LOG.error("Error destroying gateway " + pid + " : " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.LOG.error("Gateway " + pid + " not found");
        }
    }

    private ZkGatewayConnector createGatewayConnector(String pid, Dictionary<String, String> properties) throws ConfigurationException {
        ZkGatewayConnector gatewayConnector = new ZkGatewayConnector();
        gatewayConnector.setZooKeeper(this.getZooKeeper());
        gatewayConnector.setFabricService(this.getFabricService());
        gatewayConnector.setId(pid);
        if (StringUtils.hasText((String)properties.get("versionName"))) {
            gatewayConnector.setVersionName(properties.get("versionName"));
        }
        if (StringUtils.hasText((String)properties.get("profileName"))) {
            gatewayConnector.setProfileName(properties.get("profileName"));
        }
        if (StringUtils.hasText((String)properties.get("inboundDestinationsRef"))) {
            gatewayConnector.setInboundDestinations(this.createDestinationsConfig(pid, properties.get("inboundDestinationsRef")));
        }
        if (StringUtils.hasText((String)properties.get("outboundDestinationsRef"))) {
            gatewayConnector.setOutboundDestinations(this.createDestinationsConfig(pid, properties.get("outboundDestinationsRef")));
        }
        gatewayConnector.setLocalBrokerConfig(this.createBrokerConfig(pid, "localBroker", properties));
        gatewayConnector.setExportedBrokerConfig(this.createBrokerConfig(pid, "exportedBroker", properties));
        gatewayConnector.setApplicationContext(this.createApplicationContext(pid));
        try {
            gatewayConnector.afterPropertiesSet();
            gatewayConnector.start();
        }
        catch (Exception e) {
            String msg = "Error starting gateway " + pid + " : " + e.getMessage();
            this.LOG.error(msg);
            throw new ConfigurationException("Start", msg, (Throwable)e);
        }
        return gatewayConnector;
    }
}

