/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.spring;

import org.fusesource.fabric.bridge.spring.BridgeConnectorParser;
import org.fusesource.fabric.bridge.spring.GatewayConnectorParser;
import org.fusesource.fabric.bridge.zk.ZkBridgeConnector;
import org.fusesource.fabric.bridge.zk.ZkGatewayConnector;
import org.fusesource.fabric.bridge.zk.model.ZkBridgeDestinationsConfigFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZkBridgeNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String ZKBRIDGE_NS = "http://fusesource.org/fabric/bridge/zookeeper";
    private static final String FABRIC_SERVICE_ATTRIBUTE = "fabricServiceRef";
    private static final String FABRIC_SERVICE_PROPERTY = "fabricService";
    private static final String ZOOKEEPER_ATTRIBUTE = "zooKeeperRef";
    private static final String ZOOKEEPER_PROPERTY = "zooKeeper";
    private static final String EXPORTED_BROKER_PROPERTY = "exportedBrokerConfig";
    private static final String EXPORTED_BROKER_ELEMENT = "exported-broker";

    public void init() {
        this.registerBeanDefinitionParser("zkbridge-connector", (BeanDefinitionParser)new ZkBridgeConnectorParser());
        this.registerBeanDefinitionParser("zkgateway-connector", (BeanDefinitionParser)new ZkGatewayConnectorParser());
        this.registerBeanDefinitionParser("zkbridge-destinations", (BeanDefinitionParser)new ZkBridgeDestinationsConfigParser());
    }

    private class ZkBridgeDestinationsConfigParser
    extends AbstractSimpleBeanDefinitionParser {
        private ZkBridgeDestinationsConfigParser() {
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String fabricServiceRef;
            super.doParse(element, parserContext, builder);
            String id = element.getAttribute("id");
            if (StringUtils.hasText((String)id)) {
                builder.addPropertyValue("id", (Object)id);
            }
            if (StringUtils.hasText((String)(fabricServiceRef = element.getAttribute(ZkBridgeNamespaceHandler.FABRIC_SERVICE_ATTRIBUTE)))) {
                builder.addPropertyReference(ZkBridgeNamespaceHandler.FABRIC_SERVICE_PROPERTY, fabricServiceRef);
            }
        }

        protected Class getBeanClass(Element element) {
            return ZkBridgeDestinationsConfigFactory.class;
        }
    }

    private class ZkGatewayConnectorParser
    extends GatewayConnectorParser {
        private ZkGatewayConnectorParser() {
        }

        protected Class getBeanClass(Element element) {
            return ZkGatewayConnector.class;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String fabricServiceRef;
            String zooKeeperRef;
            super.doParse(element, parserContext, builder);
            NodeList nodes = element.getElementsByTagNameNS(ZkBridgeNamespaceHandler.ZKBRIDGE_NS, ZkBridgeNamespaceHandler.EXPORTED_BROKER_ELEMENT);
            if (nodes != null && nodes.getLength() == 1) {
                Element exportedBroker = (Element)nodes.item(0);
                builder.addPropertyValue(ZkBridgeNamespaceHandler.EXPORTED_BROKER_PROPERTY, (Object)this.brokerConfigParser.parse(element, parserContext));
            }
            if (StringUtils.hasText((String)(zooKeeperRef = element.getAttribute(ZkBridgeNamespaceHandler.ZOOKEEPER_ATTRIBUTE)))) {
                builder.addPropertyReference(ZkBridgeNamespaceHandler.ZOOKEEPER_PROPERTY, zooKeeperRef);
            }
            if (StringUtils.hasText((String)(fabricServiceRef = element.getAttribute(ZkBridgeNamespaceHandler.FABRIC_SERVICE_ATTRIBUTE)))) {
                builder.addPropertyReference(ZkBridgeNamespaceHandler.FABRIC_SERVICE_PROPERTY, fabricServiceRef);
            }
        }
    }

    private class ZkBridgeConnectorParser
    extends BridgeConnectorParser {
        private ZkBridgeConnectorParser() {
        }

        protected Class getBeanClass(Element element) {
            return ZkBridgeConnector.class;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String fabricServiceRef;
            String zooKeeperRef;
            super.doParse(element, parserContext, builder);
            NodeList nodes = element.getElementsByTagNameNS(ZkBridgeNamespaceHandler.ZKBRIDGE_NS, ZkBridgeNamespaceHandler.EXPORTED_BROKER_ELEMENT);
            if (nodes != null && nodes.getLength() == 1) {
                Element exportedBroker = (Element)nodes.item(0);
                builder.addPropertyValue(ZkBridgeNamespaceHandler.EXPORTED_BROKER_PROPERTY, (Object)this.brokerConfigParser.parse(element, parserContext));
            }
            if (StringUtils.hasText((String)(zooKeeperRef = element.getAttribute(ZkBridgeNamespaceHandler.ZOOKEEPER_ATTRIBUTE)))) {
                builder.addPropertyReference(ZkBridgeNamespaceHandler.ZOOKEEPER_PROPERTY, zooKeeperRef);
            }
            if (StringUtils.hasText((String)(fabricServiceRef = element.getAttribute(ZkBridgeNamespaceHandler.FABRIC_SERVICE_ATTRIBUTE)))) {
                builder.addPropertyReference(ZkBridgeNamespaceHandler.FABRIC_SERVICE_PROPERTY, fabricServiceRef);
            }
        }
    }
}

