/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.bridge.model.BridgeDestinationsConfig;
import org.fusesource.fabric.bridge.model.BridgedDestination;
import org.fusesource.fabric.bridge.model.DispatchPolicy;
import org.fusesource.fabric.bridge.model.IdentifiedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

@XmlRootElement(name="zkbridge-destinations")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ZkBridgeDestinationsConfigFactory
extends IdentifiedType
implements FactoryBean<BridgeDestinationsConfig>,
InitializingBean {
    private static final String BRIDGE_DESTINATIONS_PID = "org.fusesource.fabric.bridge.bridgeDestinationsConfig";
    private static final String DISPATCH_POLICY_PID = "org.fusesource.fabric.bridge.dispatchPolicy";
    private static final String PID_XML_EXTENSION = ".xml";
    private static JAXBContext jaxbContext;
    private static final Logger LOG;
    private static final String NAME_SUFFIX = ".name";
    private FabricService fabricService;
    @XmlAttribute(required=true)
    private String fabricServiceRef;

    public BridgeDestinationsConfig getObject() throws Exception {
        Container container = this.fabricService.getContainer(System.getProperty("karaf.name"));
        String bridgeDestinationsXml = "org.fusesource.fabric.bridge.bridgeDestinationsConfig." + this.getId() + PID_XML_EXTENSION;
        String bridgeDestinationsProperties = "org.fusesource.fabric.bridge.bridgeDestinationsConfig." + this.getId();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (Profile profile : container.getProfiles()) {
            if (profile.getParents().length > 0) {
                profile = profile.getOverlay();
            }
            profiles.add(profile);
        }
        for (Profile profile : profiles) {
            byte[] bytes = (byte[])profile.getFileConfigurations().get(bridgeDestinationsXml);
            if (bytes != null) {
                Object object = jaxbContext.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(bytes));
                if (object instanceof BridgeDestinationsConfig) {
                    return (BridgeDestinationsConfig)object;
                }
                String msg = "Object at " + bridgeDestinationsXml + " is not of type " + BridgeDestinationsConfig.class.getName() + ", but instead of type " + object.getClass().getName();
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            Map properties = (Map)profile.getConfigurations().get(bridgeDestinationsProperties);
            if (properties == null) continue;
            try {
                return this.getBridgeDestinationsProperties(profiles, properties);
            }
            catch (BeansException e) {
                String msg = "Error parsing config properties " + bridgeDestinationsProperties + ": " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw new BeanCreationException(msg, (Throwable)e);
            }
        }
        String msg = "No configuration " + bridgeDestinationsXml + " or " + bridgeDestinationsProperties + " found in container profiles";
        LOG.error(msg);
        throw new BeanCreationException(msg);
    }

    private BridgeDestinationsConfig getBridgeDestinationsProperties(List<Profile> profiles, Map<String, String> properties) throws BeansException {
        BridgeDestinationsConfig config = new BridgeDestinationsConfig();
        properties.put("id", this.getId());
        HashSet<String> prefixSet = new HashSet<String>();
        for (String key : properties.keySet()) {
            if (!key.endsWith(NAME_SUFFIX)) continue;
            String prefix = key.substring(0, key.length() - NAME_SUFFIX.length() + 1);
            if (prefix.matches("^[0-9]+\\.")) {
                prefixSet.add(prefix);
                continue;
            }
            String msg = "Invalid destination name " + key + ", must be of the form [0-9]+\\.name";
            LOG.error(msg);
            throw new BeanCreationException(msg);
        }
        HashMap<String, String> configProperties = new HashMap<String, String>();
        for (String key : properties.keySet()) {
            boolean skip = false;
            for (String prefix : prefixSet) {
                if (!key.startsWith(prefix)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            configProperties.put(key, properties.get(key));
        }
        ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)config);
        accessor.setPropertyValues(configProperties);
        HashMap<String, DispatchPolicy> dispatchPolicies = new HashMap<String, DispatchPolicy>();
        config.setDestinations(this.getDestinations(properties, prefixSet, this.getId(), profiles, dispatchPolicies));
        String dispatchPolicyRef = config.getDispatchPolicyRef();
        if (StringUtils.hasText((String)dispatchPolicyRef)) {
            config.setDispatchPolicy(this.getDispatchPolicy(dispatchPolicies, profiles, dispatchPolicyRef, this.getId() + "." + dispatchPolicyRef));
        }
        return config;
    }

    private DispatchPolicy getDispatchPolicy(Map<String, DispatchPolicy> dispatchPolicies, List<Profile> profiles, String dispatchPolicyRef, String id) {
        String dispatchPolicyConfig = "org.fusesource.fabric.bridge.dispatchPolicy." + dispatchPolicyRef;
        if (dispatchPolicies.get(dispatchPolicyConfig) != null) {
            return dispatchPolicies.get(dispatchPolicyConfig);
        }
        for (Profile profile : profiles) {
            Map properties = (Map)profile.getConfigurations().get(dispatchPolicyConfig);
            if (properties == null) continue;
            DispatchPolicy dispatchPolicy = new DispatchPolicy();
            dispatchPolicy.setId(id);
            ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)dispatchPolicy);
            accessor.setPropertyValues(properties);
            dispatchPolicies.put(dispatchPolicyConfig, dispatchPolicy);
            return dispatchPolicy;
        }
        String msg = "No configuration " + dispatchPolicyConfig + " found in container profiles";
        LOG.error(msg);
        throw new BeanCreationException(msg);
    }

    private List<BridgedDestination> getDestinations(Map<String, String> properties, Set<String> prefixSet, String id, List<Profile> profiles, Map<String, DispatchPolicy> dispatchPolicies) {
        ArrayList<BridgedDestination> destinations = new ArrayList<BridgedDestination>();
        for (String prefix : prefixSet) {
            HashMap<String, String> destinationProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                destinationProps.put(entry.getKey().substring(prefix.length()), entry.getValue());
            }
            BridgedDestination destination = new BridgedDestination();
            String destinationId = id + "." + prefix.substring(0, prefix.length() - 1);
            destination.setId(destinationId);
            ConfigurablePropertyAccessor accessor = PropertyAccessorFactory.forDirectFieldAccess((Object)destination);
            accessor.setPropertyValues(destinationProps);
            String dispatchPolicyRef = destination.getDispatchPolicyRef();
            if (StringUtils.hasText((String)dispatchPolicyRef)) {
                destination.setDispatchPolicy(this.getDispatchPolicy(dispatchPolicies, profiles, dispatchPolicyRef, destinationId + "." + dispatchPolicyRef));
            }
            destinations.add(destination);
        }
        return destinations;
    }

    public Class<?> getObjectType() {
        return BridgeDestinationsConfig.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Property name must be set");
        }
        if (this.getFabricService() == null) {
            throw new IllegalArgumentException("Property fabricService must be set");
        }
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public String getFabricServiceRef() {
        return this.fabricServiceRef;
    }

    public void setFabricServiceRef(String fabricServiceRef) {
        this.fabricServiceRef = fabricServiceRef;
    }

    static {
        LOG = LoggerFactory.getLogger(ZkBridgeDestinationsConfigFactory.class);
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BridgeDestinationsConfig.class});
        }
        catch (JAXBException e) {
            String msg = "Error creating JAXB context for " + BridgeDestinationsConfig.class + " : " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }
}

