/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.fabric.bridge.zk.ZkBridgeConnector;
import org.fusesource.fabric.bridge.zk.internal.AbstractZkManagedServiceFactory;
import org.osgi.service.cm.ConfigurationException;
import org.springframework.util.StringUtils;

public class ZkManagedBridgeServiceFactory
extends AbstractZkManagedServiceFactory {
    private Map<String, ZkBridgeConnector> bridgeConnectorMap = new ConcurrentHashMap<String, ZkBridgeConnector>();

    @Override
    public void doDestroy() throws Exception {
        for (String pid : this.bridgeConnectorMap.keySet()) {
            this.deleted(pid);
        }
    }

    public String getName() {
        return "Fabric Bridge Server";
    }

    public void updated(String pid, Dictionary incoming) throws ConfigurationException {
        if (this.bridgeConnectorMap.containsKey(pid)) {
            this.LOG.info("Refreshing Bridge " + pid);
            this.deleted(pid);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        Enumeration keys = incoming.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = incoming.get(key);
            if (value == null) continue;
            ((Dictionary)properties).put(key, value.toString());
        }
        this.bridgeConnectorMap.put(pid, this.createBridgeConnector(pid, properties));
        this.LOG.info("Started Bridge " + pid);
    }

    @Override
    public void doDeleted(String pid) {
        ZkBridgeConnector bridgeConnector = this.bridgeConnectorMap.remove(pid);
        if (bridgeConnector != null) {
            try {
                bridgeConnector.destroy();
                this.LOG.info("Destroyed Bridge " + pid);
            }
            catch (Exception e) {
                this.LOG.error("Error destroying bridge " + pid + " : " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.LOG.error("Bridge " + pid + " not found");
        }
    }

    private ZkBridgeConnector createBridgeConnector(String pid, Dictionary<String, String> properties) throws ConfigurationException {
        ZkBridgeConnector bridgeConnector = new ZkBridgeConnector();
        bridgeConnector.setZooKeeper(this.getZooKeeper());
        bridgeConnector.setFabricService(this.getFabricService());
        bridgeConnector.setId(pid);
        if (StringUtils.hasText((String)properties.get("versionName"))) {
            bridgeConnector.setVersionName(properties.get("versionName"));
        }
        if (StringUtils.hasText((String)properties.get("gatewayProfileName"))) {
            bridgeConnector.setGatewayProfileName(properties.get("gatewayProfileName"));
        }
        if (StringUtils.hasText((String)properties.get("gatewayConnectRetries"))) {
            bridgeConnector.setGatewayConnectRetries(Integer.parseInt(properties.get("gatewayConnectRetries")));
        }
        if (StringUtils.hasText((String)properties.get("gatewayStartupDelay"))) {
            bridgeConnector.setGatewayStartupDelay(Integer.parseInt(properties.get("gatewayStartupDelay")));
        }
        if (StringUtils.hasText((String)properties.get("inboundDestinationsRef"))) {
            bridgeConnector.setInboundDestinations(this.createDestinationsConfig(pid, properties.get("inboundDestinationsRef")));
        }
        if (StringUtils.hasText((String)properties.get("outboundDestinationsRef"))) {
            bridgeConnector.setOutboundDestinations(this.createDestinationsConfig(pid, properties.get("outboundDestinationsRef")));
        }
        bridgeConnector.setLocalBrokerConfig(this.createBrokerConfig(pid, "localBroker", properties));
        bridgeConnector.setExportedBrokerConfig(this.createBrokerConfig(pid, "exportedBroker", properties));
        bridgeConnector.setApplicationContext(this.createApplicationContext(pid));
        try {
            bridgeConnector.afterPropertiesSet();
            bridgeConnector.start();
        }
        catch (Exception e) {
            String msg = "Error starting bridge " + pid + " : " + e.getMessage();
            this.LOG.error(msg);
            throw new ConfigurationException("Start", msg, (Throwable)e);
        }
        return bridgeConnector;
    }
}

