/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.bridge.BridgeConnector;
import org.fusesource.fabric.bridge.model.BrokerConfig;
import org.fusesource.fabric.bridge.model.RemoteBridge;
import org.fusesource.fabric.bridge.zk.internal.ZkConfigHelper;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextAware;

@XmlRootElement(name="zkbridge-connector")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ZkBridgeConnector
extends BridgeConnector
implements LifecycleListener,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ZkBridgeConnector.class);
    private static final String BRIDGE_PID = "org.fusesource.fabric.bridge";
    @XmlElement(name="exported-broker")
    private BrokerConfig exportedBrokerConfig;
    @XmlAttribute
    private String versionName;
    @XmlAttribute(required=true)
    private String gatewayProfileName;
    @XmlAttribute
    private int gatewayStartupDelay = 10;
    @XmlAttribute
    private int gatewayConnectRetries = 5;
    @XmlAttribute(required=true)
    private String zooKeeperRef;
    private IZKClient zooKeeper;
    @XmlAttribute(required=true)
    private String fabricServiceRef;
    private FabricService fabricService;
    private transient boolean connected;
    private Profile gatewayProfile;
    private Container container;

    public void afterPropertiesSet() throws Exception {
        RemoteBridge gatewayBridge;
        if (this.gatewayProfileName == null) {
            throw new IllegalArgumentException("Property profile must be set");
        }
        if (this.zooKeeper == null) {
            throw new IllegalArgumentException("Property zooKeeper must be set");
        }
        if (this.fabricService == null) {
            throw new IllegalArgumentException("Property fabricService must be set");
        }
        this.zooKeeper.registerListener((LifecycleListener)this);
        this.connected = true;
        if (this.exportedBrokerConfig == null) {
            LOG.warn("The property exportedBrokerConfig is not set, exporting property localBrokerConfig");
        } else if (this.exportedBrokerConfig.getBrokerUrl() == null && this.exportedBrokerConfig.getConnectionFactory() == null || this.exportedBrokerConfig.getBrokerUrl() != null && this.exportedBrokerConfig.getConnectionFactory() != null) {
            throw new IllegalArgumentException("Either a exported broker url or connection factory must be provided");
        }
        if (this.versionName == null) {
            this.versionName = this.fabricService.getDefaultVersion().getName();
        }
        LOG.info("Looking for profile " + this.gatewayProfileName + " under version " + this.versionName);
        Version version = this.fabricService.getVersion(this.versionName);
        this.gatewayProfile = version.getProfile(this.gatewayProfileName);
        if (this.gatewayProfile == null) {
            throw new IllegalArgumentException("Gateway connector profile " + this.gatewayProfileName + " does not exist");
        }
        int attempts = this.gatewayConnectRetries;
        do {
            if ((gatewayBridge = ZkConfigHelper.getGatewayConfig(this.gatewayProfile, this.applicationContext)) != null) continue;
            LOG.warn("Gateway configuration not found in profile " + this.gatewayProfileName + ", waiting for " + this.gatewayStartupDelay + " seconds, retries remaining " + attempts);
            Thread.sleep((long)this.gatewayStartupDelay * 1000L);
        } while (--attempts > 0);
        if (gatewayBridge == null) {
            String msg = "Gateway configuration not found in profile " + this.gatewayProfileName;
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        super.setRemoteBrokerConfig(gatewayBridge.getRemoteBrokerConfig());
        if (this.getInboundDestinations() != null) {
            if (gatewayBridge.getOutboundDestinations() == null) {
                LOG.info("Using inbound destinations from Bridge, Gateway has no default destinations");
            } else {
                LOG.warn("Using inbound destinations from Bridge, Gateway default destinations will be ignored");
            }
        } else if (gatewayBridge.getOutboundDestinations() != null) {
            LOG.info("No inbound destinations in Bridge, Gateway destinations will be used");
        } else {
            LOG.warn("No inbound destinations in Bridge or Gateway, Bridge will be unidirectional from Bridge To Gateway");
        }
        super.setInboundDestinations(this.getInboundDestinations() != null ? this.getInboundDestinations() : gatewayBridge.getOutboundDestinations());
        super.afterPropertiesSet();
    }

    protected void doInitialize() {
        super.doInitialize();
        this.container = this.fabricService.getContainer(System.getProperty("karaf.name"));
        RemoteBridge remoteBridge = new RemoteBridge();
        remoteBridge.setRemoteBrokerConfig(this.exportedBrokerConfig != null ? this.exportedBrokerConfig : super.getLocalBrokerConfig());
        remoteBridge.setInboundDestinations(super.getOutboundDestinations());
        remoteBridge.setOutboundDestinations(super.getInboundDestinations());
        ZkConfigHelper.registerBridge(this.zooKeeper, this.container, remoteBridge);
    }

    protected void doStop() {
        if (this.connected) {
            try {
                this.zooKeeper.removeListener((LifecycleListener)this);
                this.connected = false;
            }
            catch (Exception e) {
                LOG.error("Error removing Bridge Connector as ZooKeeper listener: " + e.getMessage(), (Throwable)e);
            }
        }
        super.doStop();
        LOG.info("Stopped");
    }

    protected void doDestroy() throws Exception {
        try {
            super.doDestroy();
        }
        catch (Exception e) {
            LOG.warn("Error destroying Bridge: " + e.getMessage(), (Throwable)e);
        }
        if (this.container != null) {
            if (this.connected) {
                ZkConfigHelper.removeBridge(this.zooKeeper, this.container);
            } else {
                LOG.error("Bridge disconnected from Fabric Zookeeper service, unable to remove Bridge runtime configuration");
            }
        }
    }

    public void onConnected() {
        LOG.info("Bridge connected to Fabric Zookeeper service");
        this.connected = true;
    }

    public void onDisconnected() {
        LOG.warn("Bridge disconnected from Fabric Zookeeper service");
        this.connected = false;
    }

    public BrokerConfig getExportedBrokerConfig() {
        return this.exportedBrokerConfig;
    }

    public void setExportedBrokerConfig(BrokerConfig exportedBrokerConfig) {
        this.exportedBrokerConfig = exportedBrokerConfig;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getGatewayProfileName() {
        return this.gatewayProfileName;
    }

    public void setGatewayProfileName(String gatewayProfileName) {
        this.gatewayProfileName = gatewayProfileName;
    }

    public String getZooKeeperRef() {
        return this.zooKeeperRef;
    }

    public void setZooKeeperRef(String zooKeeperRef) {
        this.zooKeeperRef = zooKeeperRef;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public String getFabricServiceRef() {
        return this.fabricServiceRef;
    }

    public void setFabricServiceRef(String fabricServiceRef) {
        this.fabricServiceRef = fabricServiceRef;
    }

    public int getGatewayStartupDelay() {
        return this.gatewayStartupDelay;
    }

    public void setGatewayStartupDelay(int gatewayStartupDelay) {
        this.gatewayStartupDelay = gatewayStartupDelay;
    }

    public int getGatewayConnectRetries() {
        return this.gatewayConnectRetries;
    }

    public void setGatewayConnectRetries(int gatewayConnectRetries) {
        this.gatewayConnectRetries = gatewayConnectRetries;
    }
}

