/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.bridge.MessageConverter;
import org.fusesource.fabric.bridge.model.BridgeDestinationsConfig;
import org.fusesource.fabric.bridge.model.BridgedDestination;
import org.fusesource.fabric.bridge.model.BrokerConfig;
import org.fusesource.fabric.bridge.model.DispatchPolicy;
import org.fusesource.fabric.bridge.zk.internal.OsgiApplicationContextAdapter;
import org.fusesource.fabric.bridge.zk.model.ZkBridgeDestinationsConfigFactory;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.StringUtils;

public abstract class AbstractZkManagedServiceFactory
implements ManagedServiceFactory {
    private static final String CONNECTION_FACTORY_CLASS_NAME = ConnectionFactory.class.getName();
    private static final String DESTINATION_RESOLVER_CLASS_NAME = DestinationResolver.class.getName();
    private static final String MESSAGE_CONVERTER_CLASS_NAME = MessageConverter.class.getName();
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private IZKClient zooKeeper;
    private FabricService fabricService;
    private BundleContext bundleContext;
    protected Map<String, List<ServiceReference>> serviceReferenceMap = new ConcurrentHashMap<String, List<ServiceReference>>();

    public final void init() throws Exception {
        if (this.zooKeeper == null) {
            throw new IllegalArgumentException("Property zooKeeper must be set!");
        }
        if (this.fabricService == null) {
            throw new IllegalArgumentException("Property fabricService must be set!");
        }
        if (this.bundleContext == null) {
            throw new IllegalArgumentException("Property bundleContext must be set!");
        }
        this.LOG.info("Started");
    }

    public final void destroy() throws Exception {
        this.doDestroy();
        if (!this.serviceReferenceMap.isEmpty()) {
            this.LOG.error("Removing " + this.serviceReferenceMap.size() + " left over Service references");
            for (List<ServiceReference> references : this.serviceReferenceMap.values()) {
                for (ServiceReference reference : references) {
                    this.bundleContext.ungetService(reference);
                }
            }
        }
        this.LOG.info("Destroyed");
    }

    protected abstract void doDestroy() throws Exception;

    public final void deleted(String pid) {
        this.doDeleted(pid);
        if (this.serviceReferenceMap.containsKey(pid)) {
            for (ServiceReference reference : this.serviceReferenceMap.remove(pid)) {
                this.bundleContext.ungetService(reference);
            }
        }
        this.LOG.info("Removed " + pid);
    }

    protected abstract void doDeleted(String var1);

    protected BridgeDestinationsConfig createDestinationsConfig(String pid, String destinationsRef) throws ConfigurationException {
        ZkBridgeDestinationsConfigFactory factory = new ZkBridgeDestinationsConfigFactory();
        factory.setFabricService(this.fabricService);
        factory.setId(destinationsRef);
        try {
            BridgeDestinationsConfig destinationsConfig = factory.getObject();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Found [" + pid + "." + destinationsRef + "]: " + destinationsConfig);
            }
            DispatchPolicy dispatchPolicy = destinationsConfig.getDispatchPolicy();
            this.resolveDispatchPolicyRefs(pid, dispatchPolicy);
            for (BridgedDestination destination : destinationsConfig.getDestinations()) {
                if (destination.getDispatchPolicy() == null) continue;
                this.resolveDispatchPolicyRefs(pid, destination.getDispatchPolicy());
            }
            return destinationsConfig;
        }
        catch (Exception e) {
            String msg = "Error getting destinations for " + pid + "." + destinationsRef + " : " + e.getMessage();
            this.LOG.error(msg, (Throwable)e);
            throw new ConfigurationException(destinationsRef, msg, (Throwable)e);
        }
    }

    private void resolveDispatchPolicyRefs(String pid, DispatchPolicy dispatchPolicy) throws ConfigurationException {
        String messageConverterRef = dispatchPolicy.getMessageConverterRef();
        if (StringUtils.hasText((String)messageConverterRef)) {
            ServiceReference[] serviceReferences;
            String filter = "(service.pid=" + messageConverterRef + ")";
            try {
                serviceReferences = this.bundleContext.getServiceReferences(MESSAGE_CONVERTER_CLASS_NAME, filter);
            }
            catch (InvalidSyntaxException e1) {
                String msg = "Error looking up " + messageConverterRef + " with filter [" + filter + "]";
                this.LOG.error(msg);
                throw new ConfigurationException(messageConverterRef, msg);
            }
            if (serviceReferences != null) {
                dispatchPolicy.setMessageConverter((MessageConverter)this.bundleContext.getService(serviceReferences[0]));
                this.addServiceReference(pid, serviceReferences[0]);
            } else {
                String msg = "No service found for " + messageConverterRef + " with filter [" + filter + "]";
                this.LOG.error(msg);
                throw new ConfigurationException(messageConverterRef, msg);
            }
        }
    }

    protected BrokerConfig createBrokerConfig(String pid, String prefix, Dictionary<String, String> properties) throws ConfigurationException {
        String keyPrefix = prefix + ".";
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String destinationResolverRef;
            String connectionFactoryRef;
            String key = e.nextElement();
            if (!key.startsWith(keyPrefix)) continue;
            BrokerConfig config = new BrokerConfig();
            config.setId(pid + "." + prefix);
            config.setBrokerUrl(properties.get(prefix + ".brokerUrl"));
            config.setClientId(properties.get(prefix + ".clientId"));
            config.setUserName(properties.get(prefix + ".userName"));
            config.setPassword(properties.get(prefix + ".password"));
            if (StringUtils.hasText((String)properties.get(prefix + ".maxConnections"))) {
                config.setMaxConnections(Integer.parseInt(properties.get(prefix + ".maxConnections")));
            }
            if (StringUtils.hasText((String)(connectionFactoryRef = properties.get(prefix + ".connectionFactoryRef")))) {
                ServiceReference[] serviceReferences;
                String filter = "(service.pid=" + connectionFactoryRef + ")";
                try {
                    serviceReferences = this.bundleContext.getServiceReferences(CONNECTION_FACTORY_CLASS_NAME, filter);
                }
                catch (InvalidSyntaxException e1) {
                    String msg = "Error looking up " + connectionFactoryRef + " with filter [" + filter + "]";
                    this.LOG.error(msg);
                    throw new ConfigurationException(connectionFactoryRef, msg);
                }
                if (serviceReferences != null) {
                    config.setConnectionFactoryRef(connectionFactoryRef);
                    config.setConnectionFactory((ConnectionFactory)this.bundleContext.getService(serviceReferences[0]));
                    this.addServiceReference(pid, serviceReferences[0]);
                } else {
                    String msg = "No service found for " + connectionFactoryRef + " with filter [" + filter + "]";
                    this.LOG.error(msg);
                    throw new ConfigurationException(connectionFactoryRef, msg);
                }
            }
            if (StringUtils.hasText((String)(destinationResolverRef = properties.get(prefix + ".destinationResolverRef")))) {
                ServiceReference[] serviceReferences;
                String filter = "(service.pid=" + destinationResolverRef + ")";
                try {
                    serviceReferences = this.bundleContext.getServiceReferences(DESTINATION_RESOLVER_CLASS_NAME, filter);
                }
                catch (InvalidSyntaxException e1) {
                    String msg = "Error looking up " + destinationResolverRef + " with filter [" + filter + "]";
                    this.LOG.error(msg);
                    throw new ConfigurationException(destinationResolverRef, msg);
                }
                if (serviceReferences != null) {
                    config.setDestinationResolverRef(destinationResolverRef);
                    config.setDestinationResolver((DestinationResolver)this.bundleContext.getService(serviceReferences[0]));
                    this.addServiceReference(pid, serviceReferences[0]);
                } else {
                    String msg = "No service found for " + destinationResolverRef + " with filter [" + filter + "]";
                    this.LOG.error(msg);
                    throw new ConfigurationException(destinationResolverRef, msg);
                }
            }
            return config;
        }
        this.LOG.info("No Broker configuration found in " + pid + " for " + prefix);
        return null;
    }

    void addServiceReference(String pid, ServiceReference serviceReference) {
        List<ServiceReference> serviceReferences = this.serviceReferenceMap.get(pid);
        if (serviceReferences != null) {
            serviceReferences.add(serviceReference);
        } else {
            ArrayList<ServiceReference> references = new ArrayList<ServiceReference>();
            references.add(serviceReference);
            this.serviceReferenceMap.put(pid, references);
        }
    }

    protected final ApplicationContext createApplicationContext(String pid) {
        return (ApplicationContext)Proxy.newProxyInstance(ApplicationContext.class.getClassLoader(), new Class[]{ApplicationContext.class}, (InvocationHandler)new OsgiApplicationContextAdapter(pid, this));
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public final FabricService getFabricService() {
        return this.fabricService;
    }

    public final void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public final void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

