/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.bridge.zk.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.fusesource.fabric.bridge.zk.internal.AbstractZkManagedServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class OsgiApplicationContextAdapter
implements InvocationHandler {
    private final String pid;
    private final AbstractZkManagedServiceFactory serviceFactory;
    private final Method getBeansMethod;
    private static final Logger LOG = LoggerFactory.getLogger(OsgiApplicationContextAdapter.class);

    public OsgiApplicationContextAdapter(String pid, AbstractZkManagedServiceFactory serviceFactory) {
        this.pid = pid;
        this.serviceFactory = serviceFactory;
        try {
            this.getBeansMethod = ApplicationContext.class.getMethod("getBean", String.class, Class.class);
        }
        catch (NoSuchMethodException e) {
            String msg = "Error getting getBean method: " + e.getMessage();
            LOG.error(msg);
            throw new IllegalArgumentException(msg, e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ServiceReference[] references;
        if (!this.getBeansMethod.equals(method)) {
            String msg = "Unsupported method " + method.getName();
            LOG.error(msg);
            throw new UnsupportedOperationException(msg);
        }
        BundleContext bundleContext = this.serviceFactory.getBundleContext();
        String beanName = String.valueOf(args[0]);
        Class beanClass = (Class)args[1];
        String filter = "(service.pid=" + beanName + ")";
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("OSGi service lookup for class [%s] with filter [%s]", beanClass.getName(), filter));
        }
        if ((references = bundleContext.getServiceReferences(beanClass.getName(), filter)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Found %d OSGi services", references.length));
            }
            Object service = bundleContext.getService(references[0]);
            this.serviceFactory.addServiceReference(this.pid, references[0]);
            return service;
        }
        LOG.error("OSGi service not found for class [%s] with filter [%s]", (Object)beanClass.getName(), (Object)filter);
        throw new NoSuchBeanDefinitionException(beanName, " no such OSGi service");
    }
}

