/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.util.Iterator;
import org.apache.activemq.kaha.impl.container.MapContainerImpl;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;

public class ContainerKeySetIterator
implements Iterator {
    protected IndexItem nextItem;
    protected IndexItem currentItem;
    private MapContainerImpl container;
    private IndexLinkedList list;

    ContainerKeySetIterator(MapContainerImpl container) {
        this.container = container;
        this.list = container.getInternalList();
        this.currentItem = this.list.getRoot();
        this.nextItem = this.list.getNextEntry(this.currentItem);
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    public Object next() {
        this.currentItem = this.nextItem;
        Object result = this.container.getKey(this.nextItem);
        this.nextItem = this.list.getNextEntry(this.nextItem);
        return result;
    }

    @Override
    public void remove() {
        if (this.currentItem != null) {
            this.container.remove(this.currentItem);
            if (this.nextItem != null) {
                this.list.refreshEntry(this.nextItem);
            }
        }
    }
}

