/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.IOHelper;

@Converter
public class StaxConverter {
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;

    @Converter
    public XMLEventWriter createXMLEventWriter(OutputStream out, Exchange exchange) throws XMLStreamException {
        return this.getOutputFactory().createXMLEventWriter(IOHelper.buffered(out), IOHelper.getCharsetName(exchange));
    }

    @Converter
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return this.getOutputFactory().createXMLEventWriter(IOHelper.buffered(writer));
    }

    @Converter
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return this.getOutputFactory().createXMLEventWriter(result);
    }

    @Converter
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, Exchange exchange) throws XMLStreamException {
        return this.getOutputFactory().createXMLStreamWriter(IOHelper.buffered(outputStream), IOHelper.getCharsetName(exchange));
    }

    @Converter
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.getOutputFactory().createXMLStreamWriter(IOHelper.buffered(writer));
    }

    @Converter
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.getOutputFactory().createXMLStreamWriter(result);
    }

    @Deprecated
    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(IOHelper.buffered(in));
    }

    @Converter
    public XMLStreamReader createXMLStreamReader(InputStream in, Exchange exchange) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(IOHelper.buffered(in), IOHelper.getCharsetName(exchange));
    }

    @Converter
    public XMLStreamReader createXMLStreamReader(File file, Exchange exchange) throws XMLStreamException, FileNotFoundException {
        return this.getInputFactory().createXMLStreamReader(IOHelper.buffered(new FileInputStream(file)), IOHelper.getCharsetName(exchange));
    }

    @Converter
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(IOHelper.buffered(reader));
    }

    @Converter
    public XMLStreamReader createXMLStreamReader(Source in) throws XMLStreamException {
        return this.getInputFactory().createXMLStreamReader(in);
    }

    @Deprecated
    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        return this.getInputFactory().createXMLEventReader(IOHelper.buffered(in));
    }

    @Converter
    public XMLEventReader createXMLEventReader(InputStream in, Exchange exchange) throws XMLStreamException {
        return this.getInputFactory().createXMLEventReader(IOHelper.buffered(in), IOHelper.getCharsetName(exchange));
    }

    @Converter
    public XMLEventReader createXMLEventReader(File file, Exchange exchange) throws XMLStreamException, FileNotFoundException {
        return this.getInputFactory().createXMLEventReader(IOHelper.buffered(new FileInputStream(file)), IOHelper.getCharsetName(exchange));
    }

    @Converter
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.getInputFactory().createXMLEventReader(IOHelper.buffered(reader));
    }

    @Converter
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return this.getInputFactory().createXMLEventReader(reader);
    }

    @Converter
    public XMLEventReader createXMLEventReader(Source in) throws XMLStreamException {
        return this.getInputFactory().createXMLEventReader(in);
    }

    public XMLInputFactory getInputFactory() {
        if (this.inputFactory == null) {
            this.inputFactory = XMLInputFactory.newInstance();
        }
        return this.inputFactory;
    }

    public void setInputFactory(XMLInputFactory inputFactory) {
        this.inputFactory = inputFactory;
    }

    public XMLOutputFactory getOutputFactory() {
        if (this.outputFactory == null) {
            this.outputFactory = XMLOutputFactory.newInstance();
        }
        return this.outputFactory;
    }

    public void setOutputFactory(XMLOutputFactory outputFactory) {
        this.outputFactory = outputFactory;
    }
}

