/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedOutputStream
extends OutputStream {
    public static final String THRESHOLD = "CamelCachedOutputStreamThreshold";
    public static final String TEMP_DIR = "CamelCachedOutputStreamOutputDirectory";
    private static final transient Logger LOG = LoggerFactory.getLogger(CachedOutputStream.class);
    private OutputStream currentStream = new ByteArrayOutputStream(2048);
    private boolean inMemory = true;
    private int totalLength;
    private File tempFile;
    private FileInputStreamCache fileInputStreamCache;
    private long threshold = 65536L;
    private File outputDir;

    public CachedOutputStream(Exchange exchange) {
        this(exchange, true);
    }

    public CachedOutputStream(Exchange exchange, boolean closedOnCompletion) {
        String hold = exchange.getContext().getProperties().get(THRESHOLD);
        String dir = exchange.getContext().getProperties().get(TEMP_DIR);
        if (hold != null) {
            this.threshold = exchange.getContext().getTypeConverter().convertTo(Long.class, hold);
        }
        if (dir != null) {
            this.outputDir = exchange.getContext().getTypeConverter().convertTo(File.class, dir);
        }
        if (closedOnCompletion) {
            exchange.addOnCompletion(new SynchronizationAdapter(){

                @Override
                public void onDone(Exchange exchange) {
                    try {
                        if (CachedOutputStream.this.fileInputStreamCache != null) {
                            CachedOutputStream.this.fileInputStreamCache.close();
                        }
                        CachedOutputStream.this.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Error deleting temporary cache file: " + CachedOutputStream.this.tempFile, e);
                    }
                }

                public String toString() {
                    return "OnCompletion[CachedOutputStream]";
                }
            });
        }
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
        this.cleanUpTempFile();
    }

    public boolean equals(Object obj) {
        return this.currentStream.equals(obj);
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        return "CachedOutputStream[size: " + this.totalLength + "]";
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.totalLength += len;
        if (this.threshold > 0L && this.inMemory && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.pageToFileStream();
        }
        this.currentStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.totalLength += b.length;
        if (this.threshold > 0L && this.inMemory && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.totalLength;
        if (this.threshold > 0L && this.inMemory && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inMemory) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            throw new IllegalStateException("CurrentStream should be an instance of ByteArrayOutputStream but is: " + this.currentStream.getClass().getName());
        }
        try {
            if (this.fileInputStreamCache == null) {
                this.fileInputStreamCache = new FileInputStreamCache(this.tempFile);
            }
            return this.fileInputStreamCache;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file " + this.tempFile + " not found", e);
        }
    }

    public InputStream getWrappedInputStream() throws IOException {
        return new WrappedInputStream(this, this.getInputStream());
    }

    public StreamCache getStreamCache() throws IOException {
        this.flush();
        if (this.inMemory) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new InputStreamCache(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            throw new IllegalStateException("CurrentStream should be an instance of ByteArrayOutputStream but is: " + this.currentStream.getClass().getName());
        }
        try {
            if (this.fileInputStreamCache == null) {
                this.fileInputStreamCache = new FileInputStreamCache(this.tempFile);
            }
            return this.fileInputStreamCache;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file " + this.tempFile + " not found", e);
        }
    }

    private void cleanUpTempFile() {
        if (this.tempFile != null) {
            FileUtil.deleteFile(this.tempFile);
            this.tempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageToFileStream() throws IOException {
        this.flush();
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        this.tempFile = this.outputDir == null ? FileUtil.createTempFile("cos", ".tmp") : FileUtil.createTempFile("cos", ".tmp", this.outputDir);
        LOG.trace("Creating temporary stream cache file: {}", this.tempFile);
        try {
            this.currentStream = IOHelper.buffered(new FileOutputStream(this.tempFile));
            bout.writeTo(this.currentStream);
        }
        finally {
            this.inMemory = false;
        }
    }

    private static class WrappedInputStream
    extends InputStream {
        private CachedOutputStream cachedOutputStream;
        private InputStream inputStream;

        WrappedInputStream(CachedOutputStream cos, InputStream is) {
            this.cachedOutputStream = cos;
            this.inputStream = is;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
            this.cachedOutputStream.close();
        }
    }
}

