/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.IsSingleton;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ProxyInstantiationException;
import org.apache.camel.Service;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPostProcessorHelper
implements CamelContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelPostProcessorHelper.class);
    @XmlTransient
    private CamelContext camelContext;

    public CamelPostProcessorHelper() {
    }

    public CamelPostProcessorHelper(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean matchContext(String context) {
        return !ObjectHelper.isNotEmpty(context) || this.getCamelContext().getName().equals(context);
    }

    public void consumerInjection(Method method, Object bean, String beanName) {
        Consume consume = method.getAnnotation(Consume.class);
        if (consume != null && this.matchContext(consume.context())) {
            LOG.info("Creating a consumer for: " + consume);
            this.subscribeMethod(method, bean, beanName, consume.uri(), consume.ref());
        }
    }

    public void subscribeMethod(Method method, Object bean, String beanName, String endpointUri, String endpointName) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointName, injectionPointName, true);
        if (endpoint != null) {
            try {
                Processor processor = this.createConsumerProcessor(bean, method, endpoint);
                Consumer consumer = endpoint.createConsumer(processor);
                LOG.debug("Created processor: {} for consumer: {}", processor, (Object)consumer);
                this.startService(consumer, bean, beanName);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    protected void startService(Service service, Object bean, String beanName) throws Exception {
        if (this.isSingleton(bean, beanName)) {
            this.getCamelContext().addService(service);
        } else {
            LOG.debug("Service is not singleton so you must remember to stop it manually {}", service);
            ServiceHelper.startService(service);
        }
    }

    protected Processor createConsumerProcessor(Object pojo, Method method, Endpoint endpoint) {
        BeanInfo info = new BeanInfo(this.getCamelContext(), method);
        BeanProcessor answer = new BeanProcessor(pojo, info);
        return new UnitOfWorkProcessor(answer);
    }

    protected Endpoint getEndpointInjection(String uri, String name, String injectionPointName, boolean mandatory) {
        return CamelContextHelper.getEndpointInjection(this.getCamelContext(), uri, name, injectionPointName, mandatory);
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointRef, String injectionPointName, Object bean, String beanName) {
        if (type.isAssignableFrom(ProducerTemplate.class)) {
            return this.createInjectionProducerTemplate(endpointUri, endpointRef, injectionPointName);
        }
        if (type.isAssignableFrom(ConsumerTemplate.class)) {
            return this.createInjectionConsumerTemplate(endpointUri, endpointRef, injectionPointName);
        }
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointRef, injectionPointName, true);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint, bean, beanName);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint, bean, beanName);
            }
            if (type.isInterface()) {
                try {
                    return ProxyHelper.createProxy(endpoint, type);
                }
                catch (Exception e) {
                    throw this.createProxyInstantiationRuntimeException(type, endpoint, e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject/@Produce for: " + endpoint);
        }
        return null;
    }

    protected ProducerTemplate createInjectionProducerTemplate(String endpointUri, String endpointRef, String injectionPointName) {
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointRef, injectionPointName, false);
        DefaultProducerTemplate answer = new DefaultProducerTemplate(this.getCamelContext(), endpoint);
        try {
            answer.start();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected ConsumerTemplate createInjectionConsumerTemplate(String endpointUri, String endpointRef, String injectionPointName) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContext());
        try {
            answer.start();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint, Object bean, String beanName) {
        try {
            PollingConsumer pollingConsumer = endpoint.createPollingConsumer();
            this.startService(pollingConsumer, bean, beanName);
            return pollingConsumer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint, Object bean, String beanName) {
        try {
            Producer producer = endpoint.createProducer();
            this.startService(producer, bean, beanName);
            return new UnitOfWorkProducer(producer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
        return new ProxyInstantiationException(type, endpoint, e);
    }

    protected boolean isSingleton(Object bean, String beanName) {
        if (bean instanceof IsSingleton) {
            IsSingleton singleton = (IsSingleton)bean;
            return singleton.isSingleton();
        }
        return true;
    }
}

