/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBrowsableEndpointMBean;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.MessageHelper;

@ManagedResource(description="Managed BrowsableEndpoint")
public class ManagedBrowsableEndpoint
extends ManagedEndpoint
implements ManagedBrowsableEndpointMBean {
    private BrowsableEndpoint endpoint;

    public ManagedBrowsableEndpoint(BrowsableEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public BrowsableEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public long queueSize() {
        return this.endpoint.getExchanges().size();
    }

    @Override
    public String browseExchange(Integer index) {
        List<Exchange> exchanges = this.endpoint.getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.toString();
    }

    @Override
    public String browseMessageBody(Integer index) {
        List<Exchange> exchanges = this.endpoint.getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        String body = exchange.hasOut() ? exchange.getOut().getBody(String.class) : exchange.getIn().getBody(String.class);
        return body;
    }

    @Override
    public String browseMessageAsXml(Integer index) {
        return this.browseMessageAsXml(index, true);
    }

    @Override
    public String browseMessageAsXml(Integer index, Boolean includeBody) {
        List<Exchange> exchanges = this.endpoint.getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        String xml = MessageHelper.dumpAsXml(msg, includeBody);
        return xml;
    }

    @Override
    public String browseAllMessagesAsXml(Boolean includeBody) {
        return this.browseRangeMessagesAsXml(0, Integer.MAX_VALUE, includeBody);
    }

    @Override
    public String browseRangeMessagesAsXml(Integer fromIndex, Integer toIndex, Boolean includeBody) {
        if (fromIndex == null) {
            fromIndex = 0;
        }
        if (toIndex == null) {
            toIndex = Integer.MAX_VALUE;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("From index cannot be larger than to index, was: " + fromIndex + " > " + toIndex);
        }
        List<Exchange> exchanges = this.endpoint.getExchanges();
        if (exchanges.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<messages>");
        for (int i = fromIndex.intValue(); i < exchanges.size() && i <= toIndex; ++i) {
            Exchange exchange = exchanges.get(i);
            Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            String xml = MessageHelper.dumpAsXml(msg, includeBody);
            sb.append("\n").append(xml);
        }
        sb.append("\n</messages>");
        return sb.toString();
    }
}

