/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import org.apache.camel.Exchange;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentOnCompletion
implements Synchronization {
    private static final transient Logger LOG = LoggerFactory.getLogger(IdempotentOnCompletion.class);
    private final IdempotentRepository<String> idempotentRepository;
    private final String messageId;
    private final boolean eager;
    private final boolean removeOnFailure;

    public IdempotentOnCompletion(IdempotentRepository<String> idempotentRepository, String messageId, boolean eager, boolean removeOnFailure) {
        this.idempotentRepository = idempotentRepository;
        this.messageId = messageId;
        this.eager = eager;
        this.removeOnFailure = removeOnFailure;
    }

    @Override
    public void onComplete(Exchange exchange) {
        if (ExchangeHelper.isFailureHandled(exchange)) {
            this.onFailedMessage(exchange, this.messageId);
        } else {
            this.onCompletedMessage(exchange, this.messageId);
        }
    }

    @Override
    public void onFailure(Exchange exchange) {
        this.onFailedMessage(exchange, this.messageId);
    }

    protected void onCompletedMessage(Exchange exchange, String messageId) {
        if (!this.eager) {
            this.idempotentRepository.add(messageId);
        }
        this.idempotentRepository.confirm(messageId);
    }

    protected void onFailedMessage(Exchange exchange, String messageId) {
        if (this.removeOnFailure) {
            this.idempotentRepository.remove(messageId);
            LOG.debug("Removed from repository as exchange failed: {} with id: {}", exchange, (Object)messageId);
        }
    }

    public String toString() {
        return "IdempotentOnCompletion[" + this.messageId + ']';
    }
}

