/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.support.TokenPairExpressionIterator;
import org.apache.camel.util.ObjectHelper;

public class TokenXMLPairExpressionIterator
extends TokenPairExpressionIterator {
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("xmlns(:\\w+|)=\\\"(.*?)\\\"");
    private static final String SCAN_TOKEN_REGEX = "(\\s+.*?|)>";
    protected final String inheritNamespaceToken;

    public TokenXMLPairExpressionIterator(String startToken, String endToken, String inheritNamespaceToken) {
        super(startToken, endToken, true);
        this.inheritNamespaceToken = inheritNamespaceToken;
        if (!startToken.startsWith("<") || !startToken.endsWith(">")) {
            throw new IllegalArgumentException("Start token must be a valid XML token, was: " + startToken);
        }
        if (!endToken.startsWith("<") || !endToken.endsWith(">")) {
            throw new IllegalArgumentException("End token must be a valid XML token, was: " + endToken);
        }
        if (!(inheritNamespaceToken == null || inheritNamespaceToken.startsWith("<") && inheritNamespaceToken.endsWith(">"))) {
            throw new IllegalArgumentException("Namespace token must be a valid XML token, was: " + inheritNamespaceToken);
        }
    }

    @Override
    protected Iterator createIterator(InputStream in, String charset) {
        XMLTokenPairIterator iterator = new XMLTokenPairIterator(this.startToken, this.endToken, this.inheritNamespaceToken, in, charset);
        iterator.init();
        return iterator;
    }

    static class XMLTokenPairIterator
    extends TokenPairExpressionIterator.TokenPairIterator {
        private final Pattern startTokenPattern;
        private final String scanEndToken;
        private final String inheritNamespaceToken;
        private Pattern inheritNamespaceTokenPattern;
        private String rootTokenNamespaces;

        XMLTokenPairIterator(String startToken, String endToken, String inheritNamespaceToken, InputStream in, String charset) {
            super(startToken, endToken, true, in, charset);
            String token = startToken.substring(0, startToken.length() - 1) + TokenXMLPairExpressionIterator.SCAN_TOKEN_REGEX;
            this.startTokenPattern = Pattern.compile(token);
            this.scanEndToken = endToken.substring(0, endToken.length() - 1) + TokenXMLPairExpressionIterator.SCAN_TOKEN_REGEX;
            this.inheritNamespaceToken = inheritNamespaceToken;
            if (inheritNamespaceToken != null) {
                token = inheritNamespaceToken.substring(0, inheritNamespaceToken.length() - 1) + TokenXMLPairExpressionIterator.SCAN_TOKEN_REGEX;
                this.inheritNamespaceTokenPattern = Pattern.compile(token, 40);
            }
        }

        @Override
        void init() {
            this.scanner = new Scanner(this.in, this.charset).useDelimiter(this.scanEndToken);
            this.image = this.scanner.hasNext() ? (String)this.next(true) : null;
        }

        @Override
        String getNext(boolean first) {
            Matcher matcher;
            String next = this.scanner.next();
            if (next == null) {
                return null;
            }
            if (first && this.inheritNamespaceToken != null) {
                this.rootTokenNamespaces = this.getNamespacesFromNamespaceToken(next);
            }
            if (!(matcher = this.startTokenPattern.matcher(next)).find()) {
                return null;
            }
            int index = matcher.start();
            next = next.substring(index);
            StringBuilder sb = new StringBuilder();
            if (this.inheritNamespaceToken != null && this.rootTokenNamespaces != null) {
                String tag = ObjectHelper.before(next, ">");
                String text = ObjectHelper.after(next, ">");
                next = sb.append(tag).append(this.rootTokenNamespaces).append(">").append(text).append(this.endToken).toString();
            } else {
                next = sb.append(next).append(this.endToken).toString();
            }
            return next;
        }

        private String getNamespacesFromNamespaceToken(String text) {
            if (text == null) {
                return null;
            }
            Matcher mat = this.inheritNamespaceTokenPattern.matcher(text);
            if (!mat.find()) {
                return null;
            }
            text = mat.group(0);
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            Matcher matcher = NAMESPACE_PATTERN.matcher(text);
            while (matcher.find()) {
                String prefix = matcher.group(1);
                String url = matcher.group(2);
                prefix = ObjectHelper.isEmpty(prefix) ? "_DEFAULT_" : prefix.substring(1);
                namespaces.put(prefix, url);
            }
            if (namespaces.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : namespaces.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("_DEFAULT_".equals(key)) {
                    sb.append(" xmlns=\"").append(value).append("\"");
                    continue;
                }
                sb.append(" xmlns:").append(key).append("=\"").append(value).append("\"");
            }
            return sb.toString();
        }
    }
}

