/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.BitSet;

public final class UnsafeUriCharactersEncoder {
    private static BitSet unsafeCharacters;
    private static final char[] HEX_DIGITS;

    private UnsafeUriCharactersEncoder() {
    }

    public static String encode(String s) {
        int n;
        int n2 = n = s == null ? 0 : s.length();
        if (n == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        int i = 0;
        while (chars[i] <= '\u0000' || chars[i] >= '\u0080' || !unsafeCharacters.get(chars[i])) {
            if (++i < chars.length) continue;
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : chars) {
            if (ch > '\u0000' && ch < '\u0080' && unsafeCharacters.get(ch)) {
                UnsafeUriCharactersEncoder.appendEscape(sb, (byte)ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        unsafeCharacters = new BitSet(256);
        unsafeCharacters.set(32);
        unsafeCharacters.set(34);
        unsafeCharacters.set(60);
        unsafeCharacters.set(62);
        unsafeCharacters.set(35);
        unsafeCharacters.set(123);
        unsafeCharacters.set(125);
        unsafeCharacters.set(124);
        unsafeCharacters.set(92);
        unsafeCharacters.set(94);
        unsafeCharacters.set(126);
        unsafeCharacters.set(91);
        unsafeCharacters.set(93);
        unsafeCharacters.set(96);
    }
}

